// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The ParentType. </summary>
    internal readonly partial struct ParentType : IEquatable<ParentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ParentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ParentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TopicsValue = "topics";
        private const string DomainsValue = "domains";
        private const string PartnerNamespacesValue = "partnerNamespaces";

        /// <summary> topics. </summary>
        public static ParentType Topics { get; } = new ParentType(TopicsValue);
        /// <summary> domains. </summary>
        public static ParentType Domains { get; } = new ParentType(DomainsValue);
        /// <summary> partnerNamespaces. </summary>
        public static ParentType PartnerNamespaces { get; } = new ParentType(PartnerNamespacesValue);
        /// <summary> Determines if two <see cref="ParentType"/> values are the same. </summary>
        public static bool operator ==(ParentType left, ParentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ParentType"/> values are not the same. </summary>
        public static bool operator !=(ParentType left, ParentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ParentType"/>. </summary>
        public static implicit operator ParentType(string value) => new ParentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ParentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ParentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
