// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> NumberIn Advanced Filter. </summary>
    public partial class NumberInAdvancedFilter : AdvancedFilter
    {
        /// <summary> Initializes a new instance of <see cref="NumberInAdvancedFilter"/>. </summary>
        public NumberInAdvancedFilter()
        {
            Values = new ChangeTrackingList<double>();
            OperatorType = AdvancedFilterOperatorType.NumberIn;
        }

        /// <summary> Initializes a new instance of <see cref="NumberInAdvancedFilter"/>. </summary>
        /// <param name="operatorType"> The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others. </param>
        /// <param name="key"> The field/property in the event based on which you want to filter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="values"> The set of filter values. </param>
        internal NumberInAdvancedFilter(AdvancedFilterOperatorType operatorType, string key, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<double> values) : base(operatorType, key, serializedAdditionalRawData)
        {
            Values = values;
            OperatorType = operatorType;
        }

        /// <summary> The set of filter values. </summary>
        [WirePath("values")]
        public IList<double> Values { get; }
    }
}
