// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The NetworkSecurityPerimeterResourceType. </summary>
    internal readonly partial struct NetworkSecurityPerimeterResourceType : IEquatable<NetworkSecurityPerimeterResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TopicsValue = "topics";
        private const string DomainsValue = "domains";

        /// <summary> topics. </summary>
        public static NetworkSecurityPerimeterResourceType Topics { get; } = new NetworkSecurityPerimeterResourceType(TopicsValue);
        /// <summary> domains. </summary>
        public static NetworkSecurityPerimeterResourceType Domains { get; } = new NetworkSecurityPerimeterResourceType(DomainsValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterResourceType"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterResourceType left, NetworkSecurityPerimeterResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterResourceType"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterResourceType left, NetworkSecurityPerimeterResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterResourceType"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterResourceType(string value) => new NetworkSecurityPerimeterResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
