// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> NSP access rule direction. </summary>
    public readonly partial struct NetworkSecurityPerimeterProfileAccessRuleDirection : IEquatable<NetworkSecurityPerimeterProfileAccessRuleDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterProfileAccessRuleDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterProfileAccessRuleDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InboundValue = "Inbound";
        private const string OutboundValue = "Outbound";

        /// <summary> Inbound. </summary>
        public static NetworkSecurityPerimeterProfileAccessRuleDirection Inbound { get; } = new NetworkSecurityPerimeterProfileAccessRuleDirection(InboundValue);
        /// <summary> Outbound. </summary>
        public static NetworkSecurityPerimeterProfileAccessRuleDirection Outbound { get; } = new NetworkSecurityPerimeterProfileAccessRuleDirection(OutboundValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterProfileAccessRuleDirection"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterProfileAccessRuleDirection left, NetworkSecurityPerimeterProfileAccessRuleDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterProfileAccessRuleDirection"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterProfileAccessRuleDirection left, NetworkSecurityPerimeterProfileAccessRuleDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterProfileAccessRuleDirection"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterProfileAccessRuleDirection(string value) => new NetworkSecurityPerimeterProfileAccessRuleDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterProfileAccessRuleDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterProfileAccessRuleDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
