// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning issue type. </summary>
    public readonly partial struct NetworkSecurityPerimeterConfigurationIssueType : IEquatable<NetworkSecurityPerimeterConfigurationIssueType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationIssueType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterConfigurationIssueType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MissingPerimeterConfigurationValue = "MissingPerimeterConfiguration";
        private const string MissingIdentityConfigurationValue = "MissingIdentityConfiguration";
        private const string ConfigurationPropagationFailureValue = "ConfigurationPropagationFailure";
        private const string OtherValue = "Other";

        /// <summary> MissingPerimeterConfiguration. </summary>
        public static NetworkSecurityPerimeterConfigurationIssueType MissingPerimeterConfiguration { get; } = new NetworkSecurityPerimeterConfigurationIssueType(MissingPerimeterConfigurationValue);
        /// <summary> MissingIdentityConfiguration. </summary>
        public static NetworkSecurityPerimeterConfigurationIssueType MissingIdentityConfiguration { get; } = new NetworkSecurityPerimeterConfigurationIssueType(MissingIdentityConfigurationValue);
        /// <summary> ConfigurationPropagationFailure. </summary>
        public static NetworkSecurityPerimeterConfigurationIssueType ConfigurationPropagationFailure { get; } = new NetworkSecurityPerimeterConfigurationIssueType(ConfigurationPropagationFailureValue);
        /// <summary> Other. </summary>
        public static NetworkSecurityPerimeterConfigurationIssueType Other { get; } = new NetworkSecurityPerimeterConfigurationIssueType(OtherValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterConfigurationIssueType"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterConfigurationIssueType left, NetworkSecurityPerimeterConfigurationIssueType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterConfigurationIssueType"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterConfigurationIssueType left, NetworkSecurityPerimeterConfigurationIssueType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterConfigurationIssueType"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterConfigurationIssueType(string value) => new NetworkSecurityPerimeterConfigurationIssueType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterConfigurationIssueType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterConfigurationIssueType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
