// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning issue severity. </summary>
    public readonly partial struct NetworkSecurityPerimeterConfigurationIssueSeverity : IEquatable<NetworkSecurityPerimeterConfigurationIssueSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationIssueSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterConfigurationIssueSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WarningValue = "Warning";
        private const string ErrorValue = "Error";

        /// <summary> Warning. </summary>
        public static NetworkSecurityPerimeterConfigurationIssueSeverity Warning { get; } = new NetworkSecurityPerimeterConfigurationIssueSeverity(WarningValue);
        /// <summary> Error. </summary>
        public static NetworkSecurityPerimeterConfigurationIssueSeverity Error { get; } = new NetworkSecurityPerimeterConfigurationIssueSeverity(ErrorValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterConfigurationIssueSeverity"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterConfigurationIssueSeverity left, NetworkSecurityPerimeterConfigurationIssueSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterConfigurationIssueSeverity"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterConfigurationIssueSeverity left, NetworkSecurityPerimeterConfigurationIssueSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterConfigurationIssueSeverity"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterConfigurationIssueSeverity(string value) => new NetworkSecurityPerimeterConfigurationIssueSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterConfigurationIssueSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterConfigurationIssueSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
