// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state to reflect configuration state and indicate status of nsp profile configuration retrieval. </summary>
    public readonly partial struct NetworkSecurityPerimeterConfigProvisioningState : IEquatable<NetworkSecurityPerimeterConfigProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterConfigProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string DeletedValue = "Deleted";
        private const string AcceptedValue = "Accepted";

        /// <summary> Creating. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Creating { get; } = new NetworkSecurityPerimeterConfigProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Updating { get; } = new NetworkSecurityPerimeterConfigProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Deleting { get; } = new NetworkSecurityPerimeterConfigProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Succeeded { get; } = new NetworkSecurityPerimeterConfigProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Canceled { get; } = new NetworkSecurityPerimeterConfigProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Failed { get; } = new NetworkSecurityPerimeterConfigProvisioningState(FailedValue);
        /// <summary> Deleted. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Deleted { get; } = new NetworkSecurityPerimeterConfigProvisioningState(DeletedValue);
        /// <summary> Accepted. </summary>
        public static NetworkSecurityPerimeterConfigProvisioningState Accepted { get; } = new NetworkSecurityPerimeterConfigProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterConfigProvisioningState"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterConfigProvisioningState left, NetworkSecurityPerimeterConfigProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterConfigProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterConfigProvisioningState left, NetworkSecurityPerimeterConfigProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterConfigProvisioningState"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterConfigProvisioningState(string value) => new NetworkSecurityPerimeterConfigProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterConfigProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterConfigProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
