// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Network security perimeter access mode. </summary>
    public readonly partial struct NetworkSecurityPerimeterAssociationAccessMode : IEquatable<NetworkSecurityPerimeterAssociationAccessMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterAssociationAccessMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterAssociationAccessMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LearningValue = "Learning";
        private const string EnforcedValue = "Enforced";
        private const string AuditValue = "Audit";

        /// <summary> Learning. </summary>
        public static NetworkSecurityPerimeterAssociationAccessMode Learning { get; } = new NetworkSecurityPerimeterAssociationAccessMode(LearningValue);
        /// <summary> Enforced. </summary>
        public static NetworkSecurityPerimeterAssociationAccessMode Enforced { get; } = new NetworkSecurityPerimeterAssociationAccessMode(EnforcedValue);
        /// <summary> Audit. </summary>
        public static NetworkSecurityPerimeterAssociationAccessMode Audit { get; } = new NetworkSecurityPerimeterAssociationAccessMode(AuditValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterAssociationAccessMode"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterAssociationAccessMode left, NetworkSecurityPerimeterAssociationAccessMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterAssociationAccessMode"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterAssociationAccessMode left, NetworkSecurityPerimeterAssociationAccessMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterAssociationAccessMode"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterAssociationAccessMode(string value) => new NetworkSecurityPerimeterAssociationAccessMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterAssociationAccessMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterAssociationAccessMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
