// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the namespace topic. </summary>
    public readonly partial struct NamespaceTopicProvisioningState : IEquatable<NamespaceTopicProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NamespaceTopicProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NamespaceTopicProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string DeletedValue = "Deleted";
        private const string DeleteFailedValue = "DeleteFailed";
        private const string CreateFailedValue = "CreateFailed";
        private const string UpdatedFailedValue = "UpdatedFailed";

        /// <summary> Creating. </summary>
        public static NamespaceTopicProvisioningState Creating { get; } = new NamespaceTopicProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static NamespaceTopicProvisioningState Updating { get; } = new NamespaceTopicProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static NamespaceTopicProvisioningState Deleting { get; } = new NamespaceTopicProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static NamespaceTopicProvisioningState Succeeded { get; } = new NamespaceTopicProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static NamespaceTopicProvisioningState Canceled { get; } = new NamespaceTopicProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static NamespaceTopicProvisioningState Failed { get; } = new NamespaceTopicProvisioningState(FailedValue);
        /// <summary> Deleted. </summary>
        public static NamespaceTopicProvisioningState Deleted { get; } = new NamespaceTopicProvisioningState(DeletedValue);
        /// <summary> DeleteFailed. </summary>
        public static NamespaceTopicProvisioningState DeleteFailed { get; } = new NamespaceTopicProvisioningState(DeleteFailedValue);
        /// <summary> CreateFailed. </summary>
        public static NamespaceTopicProvisioningState CreateFailed { get; } = new NamespaceTopicProvisioningState(CreateFailedValue);
        /// <summary> UpdatedFailed. </summary>
        public static NamespaceTopicProvisioningState UpdatedFailed { get; } = new NamespaceTopicProvisioningState(UpdatedFailedValue);
        /// <summary> Determines if two <see cref="NamespaceTopicProvisioningState"/> values are the same. </summary>
        public static bool operator ==(NamespaceTopicProvisioningState left, NamespaceTopicProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NamespaceTopicProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(NamespaceTopicProvisioningState left, NamespaceTopicProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NamespaceTopicProvisioningState"/>. </summary>
        public static implicit operator NamespaceTopicProvisioningState(string value) => new NamespaceTopicProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NamespaceTopicProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NamespaceTopicProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
