// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Properties of the namespace topic update. </summary>
    public partial class NamespaceTopicPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NamespaceTopicPatch"/>. </summary>
        public NamespaceTopicPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NamespaceTopicPatch"/>. </summary>
        /// <param name="eventRetentionInDays">
        /// Event retention for the namespace topic expressed in days. The property default value is 1 day.
        /// Min event retention duration value is 1 day and max event retention duration value is 1 day.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NamespaceTopicPatch(int? eventRetentionInDays, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EventRetentionInDays = eventRetentionInDays;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Event retention for the namespace topic expressed in days. The property default value is 1 day.
        /// Min event retention duration value is 1 day and max event retention duration value is 1 day.
        /// </summary>
        [WirePath("properties.eventRetentionInDays")]
        public int? EventRetentionInDays { get; set; }
    }
}
