// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Properties of the Event Subscription update. </summary>
    public partial class NamespaceTopicEventSubscriptionPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NamespaceTopicEventSubscriptionPatch"/>. </summary>
        public NamespaceTopicEventSubscriptionPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NamespaceTopicEventSubscriptionPatch"/>. </summary>
        /// <param name="deliveryConfiguration"> Information about the delivery configuration of the event subscription. </param>
        /// <param name="eventDeliverySchema"> The event delivery schema for the event subscription. </param>
        /// <param name="filtersConfiguration"> Information about the filter for the event subscription. </param>
        /// <param name="expireOn"> Expiration time of the event subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NamespaceTopicEventSubscriptionPatch(DeliveryConfiguration deliveryConfiguration, DeliverySchema? eventDeliverySchema, FiltersConfiguration filtersConfiguration, DateTimeOffset? expireOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeliveryConfiguration = deliveryConfiguration;
            EventDeliverySchema = eventDeliverySchema;
            FiltersConfiguration = filtersConfiguration;
            ExpireOn = expireOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Information about the delivery configuration of the event subscription. </summary>
        [WirePath("properties.deliveryConfiguration")]
        public DeliveryConfiguration DeliveryConfiguration { get; set; }
        /// <summary> The event delivery schema for the event subscription. </summary>
        [WirePath("properties.eventDeliverySchema")]
        public DeliverySchema? EventDeliverySchema { get; set; }
        /// <summary> Information about the filter for the event subscription. </summary>
        [WirePath("properties.filtersConfiguration")]
        public FiltersConfiguration FiltersConfiguration { get; set; }
        /// <summary> Expiration time of the event subscription. </summary>
        [WirePath("properties.expirationTimeUtc")]
        public DateTimeOffset? ExpireOn { get; set; }
    }
}
