// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Information about the Monitor Alert destination for an event subscription. </summary>
    public partial class MonitorAlertEventSubscriptionDestination : EventSubscriptionDestination
    {
        /// <summary> Initializes a new instance of <see cref="MonitorAlertEventSubscriptionDestination"/>. </summary>
        public MonitorAlertEventSubscriptionDestination()
        {
            ActionGroups = new ChangeTrackingList<ResourceIdentifier>();
            EndpointType = EndpointType.MonitorAlert;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorAlertEventSubscriptionDestination"/>. </summary>
        /// <param name="endpointType"> Type of the endpoint for the event subscription destination. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="severity">
        /// The severity that will be attached to every Alert fired through this event subscription.
        /// This field must be provided.
        /// </param>
        /// <param name="description"> The description that will be attached to every Alert fired through this event subscription. </param>
        /// <param name="actionGroups">
        /// The list of ARM Ids of Action Groups that will be triggered on every Alert fired through this event subscription.
        /// Each resource ARM Id should follow this pattern: /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Insights/actionGroups/{ActionGroupName}.
        /// </param>
        internal MonitorAlertEventSubscriptionDestination(EndpointType endpointType, IDictionary<string, BinaryData> serializedAdditionalRawData, MonitorAlertSeverity? severity, string description, IList<ResourceIdentifier> actionGroups) : base(endpointType, serializedAdditionalRawData)
        {
            Severity = severity;
            Description = description;
            ActionGroups = actionGroups;
            EndpointType = endpointType;
        }

        /// <summary>
        /// The severity that will be attached to every Alert fired through this event subscription.
        /// This field must be provided.
        /// </summary>
        [WirePath("properties.severity")]
        public MonitorAlertSeverity? Severity { get; set; }
        /// <summary> The description that will be attached to every Alert fired through this event subscription. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary>
        /// The list of ARM Ids of Action Groups that will be triggered on every Alert fired through this event subscription.
        /// Each resource ARM Id should follow this pattern: /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Insights/actionGroups/{ActionGroupName}.
        /// </summary>
        [WirePath("properties.actionGroups")]
        public IList<ResourceIdentifier> ActionGroups { get; }
    }
}
