// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Information about the certificate that is used for token validation. </summary>
    public partial class IssuerCertificateInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IssuerCertificateInfo"/>. </summary>
        /// <param name="certificateUri"> Keyvault certificate URL in https://keyvaultname.vault.azure.net/certificates/certificateName/certificateVersion format. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="certificateUri"/> is null. </exception>
        public IssuerCertificateInfo(Uri certificateUri)
        {
            Argument.AssertNotNull(certificateUri, nameof(certificateUri));

            CertificateUri = certificateUri;
        }

        /// <summary> Initializes a new instance of <see cref="IssuerCertificateInfo"/>. </summary>
        /// <param name="certificateUri"> Keyvault certificate URL in https://keyvaultname.vault.azure.net/certificates/certificateName/certificateVersion format. </param>
        /// <param name="identity"> The identity that will be used to access the certificate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IssuerCertificateInfo(Uri certificateUri, CustomJwtAuthenticationManagedIdentity identity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CertificateUri = certificateUri;
            Identity = identity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IssuerCertificateInfo"/> for deserialization. </summary>
        internal IssuerCertificateInfo()
        {
        }

        /// <summary> Keyvault certificate URL in https://keyvaultname.vault.azure.net/certificates/certificateName/certificateVersion format. </summary>
        [WirePath("certificateUrl")]
        public Uri CertificateUri { get; set; }
        /// <summary> The identity that will be used to access the certificate. </summary>
        [WirePath("identity")]
        public CustomJwtAuthenticationManagedIdentity Identity { get; set; }
    }
}
