// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others. </summary>
    internal readonly partial struct FilterOperatorType : IEquatable<FilterOperatorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FilterOperatorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FilterOperatorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NumberInValue = "NumberIn";
        private const string NumberNotInValue = "NumberNotIn";
        private const string NumberLessThanValue = "NumberLessThan";
        private const string NumberGreaterThanValue = "NumberGreaterThan";
        private const string NumberLessThanOrEqualsValue = "NumberLessThanOrEquals";
        private const string NumberGreaterThanOrEqualsValue = "NumberGreaterThanOrEquals";
        private const string BoolEqualsValue = "BoolEquals";
        private const string StringInValue = "StringIn";
        private const string StringNotInValue = "StringNotIn";
        private const string StringBeginsWithValue = "StringBeginsWith";
        private const string StringEndsWithValue = "StringEndsWith";
        private const string StringContainsValue = "StringContains";
        private const string NumberInRangeValue = "NumberInRange";
        private const string NumberNotInRangeValue = "NumberNotInRange";
        private const string StringNotBeginsWithValue = "StringNotBeginsWith";
        private const string StringNotEndsWithValue = "StringNotEndsWith";
        private const string StringNotContainsValue = "StringNotContains";
        private const string IsNullOrUndefinedValue = "IsNullOrUndefined";
        private const string IsNotNullValue = "IsNotNull";

        /// <summary> NumberIn. </summary>
        public static FilterOperatorType NumberIn { get; } = new FilterOperatorType(NumberInValue);
        /// <summary> NumberNotIn. </summary>
        public static FilterOperatorType NumberNotIn { get; } = new FilterOperatorType(NumberNotInValue);
        /// <summary> NumberLessThan. </summary>
        public static FilterOperatorType NumberLessThan { get; } = new FilterOperatorType(NumberLessThanValue);
        /// <summary> NumberGreaterThan. </summary>
        public static FilterOperatorType NumberGreaterThan { get; } = new FilterOperatorType(NumberGreaterThanValue);
        /// <summary> NumberLessThanOrEquals. </summary>
        public static FilterOperatorType NumberLessThanOrEquals { get; } = new FilterOperatorType(NumberLessThanOrEqualsValue);
        /// <summary> NumberGreaterThanOrEquals. </summary>
        public static FilterOperatorType NumberGreaterThanOrEquals { get; } = new FilterOperatorType(NumberGreaterThanOrEqualsValue);
        /// <summary> BoolEquals. </summary>
        public static FilterOperatorType BoolEquals { get; } = new FilterOperatorType(BoolEqualsValue);
        /// <summary> StringIn. </summary>
        public static FilterOperatorType StringIn { get; } = new FilterOperatorType(StringInValue);
        /// <summary> StringNotIn. </summary>
        public static FilterOperatorType StringNotIn { get; } = new FilterOperatorType(StringNotInValue);
        /// <summary> StringBeginsWith. </summary>
        public static FilterOperatorType StringBeginsWith { get; } = new FilterOperatorType(StringBeginsWithValue);
        /// <summary> StringEndsWith. </summary>
        public static FilterOperatorType StringEndsWith { get; } = new FilterOperatorType(StringEndsWithValue);
        /// <summary> StringContains. </summary>
        public static FilterOperatorType StringContains { get; } = new FilterOperatorType(StringContainsValue);
        /// <summary> NumberInRange. </summary>
        public static FilterOperatorType NumberInRange { get; } = new FilterOperatorType(NumberInRangeValue);
        /// <summary> NumberNotInRange. </summary>
        public static FilterOperatorType NumberNotInRange { get; } = new FilterOperatorType(NumberNotInRangeValue);
        /// <summary> StringNotBeginsWith. </summary>
        public static FilterOperatorType StringNotBeginsWith { get; } = new FilterOperatorType(StringNotBeginsWithValue);
        /// <summary> StringNotEndsWith. </summary>
        public static FilterOperatorType StringNotEndsWith { get; } = new FilterOperatorType(StringNotEndsWithValue);
        /// <summary> StringNotContains. </summary>
        public static FilterOperatorType StringNotContains { get; } = new FilterOperatorType(StringNotContainsValue);
        /// <summary> IsNullOrUndefined. </summary>
        public static FilterOperatorType IsNullOrUndefined { get; } = new FilterOperatorType(IsNullOrUndefinedValue);
        /// <summary> IsNotNull. </summary>
        public static FilterOperatorType IsNotNull { get; } = new FilterOperatorType(IsNotNullValue);
        /// <summary> Determines if two <see cref="FilterOperatorType"/> values are the same. </summary>
        public static bool operator ==(FilterOperatorType left, FilterOperatorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FilterOperatorType"/> values are not the same. </summary>
        public static bool operator !=(FilterOperatorType left, FilterOperatorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FilterOperatorType"/>. </summary>
        public static implicit operator FilterOperatorType(string value) => new FilterOperatorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FilterOperatorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FilterOperatorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
