// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the event subscription. </summary>
    public readonly partial struct EventSubscriptionProvisioningState : IEquatable<EventSubscriptionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventSubscriptionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventSubscriptionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string AwaitingManualActionValue = "AwaitingManualAction";

        /// <summary> Creating. </summary>
        public static EventSubscriptionProvisioningState Creating { get; } = new EventSubscriptionProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static EventSubscriptionProvisioningState Updating { get; } = new EventSubscriptionProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static EventSubscriptionProvisioningState Deleting { get; } = new EventSubscriptionProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static EventSubscriptionProvisioningState Succeeded { get; } = new EventSubscriptionProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static EventSubscriptionProvisioningState Canceled { get; } = new EventSubscriptionProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static EventSubscriptionProvisioningState Failed { get; } = new EventSubscriptionProvisioningState(FailedValue);
        /// <summary> AwaitingManualAction. </summary>
        public static EventSubscriptionProvisioningState AwaitingManualAction { get; } = new EventSubscriptionProvisioningState(AwaitingManualActionValue);
        /// <summary> Determines if two <see cref="EventSubscriptionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(EventSubscriptionProvisioningState left, EventSubscriptionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventSubscriptionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(EventSubscriptionProvisioningState left, EventSubscriptionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventSubscriptionProvisioningState"/>. </summary>
        public static implicit operator EventSubscriptionProvisioningState(string value) => new EventSubscriptionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventSubscriptionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventSubscriptionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
