// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Information about the partner. </summary>
    public partial class EventGridPartnerContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventGridPartnerContent"/>. </summary>
        public EventGridPartnerContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventGridPartnerContent"/>. </summary>
        /// <param name="partnerRegistrationImmutableId"> The immutableId of the corresponding partner registration. </param>
        /// <param name="partnerName"> The partner name. </param>
        /// <param name="authorizationExpireOn">
        /// Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or delete resources in subscriber's
        /// context will fail. If specified, the allowed values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
        /// If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration or 7 if this value is not specified.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventGridPartnerContent(Guid? partnerRegistrationImmutableId, string partnerName, DateTimeOffset? authorizationExpireOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PartnerRegistrationImmutableId = partnerRegistrationImmutableId;
            PartnerName = partnerName;
            AuthorizationExpireOn = authorizationExpireOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The immutableId of the corresponding partner registration. </summary>
        [WirePath("partnerRegistrationImmutableId")]
        public Guid? PartnerRegistrationImmutableId { get; set; }
        /// <summary> The partner name. </summary>
        [WirePath("partnerName")]
        public string PartnerName { get; set; }
        /// <summary>
        /// Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or delete resources in subscriber's
        /// context will fail. If specified, the allowed values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
        /// If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration or 7 if this value is not specified.
        /// </summary>
        [WirePath("authorizationExpirationTimeInUtc")]
        public DateTimeOffset? AuthorizationExpireOn { get; set; }
    }
}
