// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Indicates if the client is enabled or not. Default value is Enabled. </summary>
    public readonly partial struct EventGridNamespaceClientState : IEquatable<EventGridNamespaceClientState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventGridNamespaceClientState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventGridNamespaceClientState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static EventGridNamespaceClientState Enabled { get; } = new EventGridNamespaceClientState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static EventGridNamespaceClientState Disabled { get; } = new EventGridNamespaceClientState(DisabledValue);
        /// <summary> Determines if two <see cref="EventGridNamespaceClientState"/> values are the same. </summary>
        public static bool operator ==(EventGridNamespaceClientState left, EventGridNamespaceClientState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventGridNamespaceClientState"/> values are not the same. </summary>
        public static bool operator !=(EventGridNamespaceClientState left, EventGridNamespaceClientState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventGridNamespaceClientState"/>. </summary>
        public static implicit operator EventGridNamespaceClientState(string value) => new EventGridNamespaceClientState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventGridNamespaceClientState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventGridNamespaceClientState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
