// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource. </summary>
    public readonly partial struct EventGridInputSchema : IEquatable<EventGridInputSchema>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventGridInputSchema"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventGridInputSchema(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EventGridSchemaValue = "EventGridSchema";
        private const string CustomEventSchemaValue = "CustomEventSchema";
        private const string CloudEventSchemaV1_0Value = "CloudEventSchemaV1_0";

        /// <summary> EventGridSchema. </summary>
        public static EventGridInputSchema EventGridSchema { get; } = new EventGridInputSchema(EventGridSchemaValue);
        /// <summary> CustomEventSchema. </summary>
        public static EventGridInputSchema CustomEventSchema { get; } = new EventGridInputSchema(CustomEventSchemaValue);
        /// <summary> Determines if two <see cref="EventGridInputSchema"/> values are the same. </summary>
        public static bool operator ==(EventGridInputSchema left, EventGridInputSchema right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventGridInputSchema"/> values are not the same. </summary>
        public static bool operator !=(EventGridInputSchema left, EventGridInputSchema right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventGridInputSchema"/>. </summary>
        public static implicit operator EventGridInputSchema(string value) => new EventGridInputSchema(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventGridInputSchema other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventGridInputSchema other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
