// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the domain topic. </summary>
    public readonly partial struct DomainTopicProvisioningState : IEquatable<DomainTopicProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DomainTopicProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DomainTopicProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static DomainTopicProvisioningState Creating { get; } = new DomainTopicProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static DomainTopicProvisioningState Updating { get; } = new DomainTopicProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static DomainTopicProvisioningState Deleting { get; } = new DomainTopicProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static DomainTopicProvisioningState Succeeded { get; } = new DomainTopicProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static DomainTopicProvisioningState Canceled { get; } = new DomainTopicProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static DomainTopicProvisioningState Failed { get; } = new DomainTopicProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="DomainTopicProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DomainTopicProvisioningState left, DomainTopicProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DomainTopicProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DomainTopicProvisioningState left, DomainTopicProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DomainTopicProvisioningState"/>. </summary>
        public static implicit operator DomainTopicProvisioningState(string value) => new DomainTopicProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DomainTopicProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DomainTopicProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
