// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The event delivery schema for the event subscription. </summary>
    public readonly partial struct DeliverySchema : IEquatable<DeliverySchema>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeliverySchema"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeliverySchema(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CloudEventSchemaV10Value = "CloudEventSchemaV1_0";

        /// <summary> CloudEventSchemaV1_0. </summary>
        public static DeliverySchema CloudEventSchemaV10 { get; } = new DeliverySchema(CloudEventSchemaV10Value);
        /// <summary> Determines if two <see cref="DeliverySchema"/> values are the same. </summary>
        public static bool operator ==(DeliverySchema left, DeliverySchema right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeliverySchema"/> values are not the same. </summary>
        public static bool operator !=(DeliverySchema left, DeliverySchema right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeliverySchema"/>. </summary>
        public static implicit operator DeliverySchema(string value) => new DeliverySchema(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeliverySchema other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeliverySchema other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
