// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Delivery mode of the event subscription. </summary>
    public readonly partial struct DeliveryMode : IEquatable<DeliveryMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeliveryMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeliveryMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueueValue = "Queue";
        private const string PushValue = "Push";

        /// <summary> Queue. </summary>
        public static DeliveryMode Queue { get; } = new DeliveryMode(QueueValue);
        /// <summary> Push. </summary>
        public static DeliveryMode Push { get; } = new DeliveryMode(PushValue);
        /// <summary> Determines if two <see cref="DeliveryMode"/> values are the same. </summary>
        public static bool operator ==(DeliveryMode left, DeliveryMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeliveryMode"/> values are not the same. </summary>
        public static bool operator !=(DeliveryMode left, DeliveryMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeliveryMode"/>. </summary>
        public static implicit operator DeliveryMode(string value) => new DeliveryMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeliveryMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeliveryMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
