// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Type of the endpoint for the dead letter destination. </summary>
    internal readonly partial struct DeadLetterEndPointType : IEquatable<DeadLetterEndPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeadLetterEndPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeadLetterEndPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StorageBlobValue = "StorageBlob";

        /// <summary> StorageBlob. </summary>
        public static DeadLetterEndPointType StorageBlob { get; } = new DeadLetterEndPointType(StorageBlobValue);
        /// <summary> Determines if two <see cref="DeadLetterEndPointType"/> values are the same. </summary>
        public static bool operator ==(DeadLetterEndPointType left, DeadLetterEndPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeadLetterEndPointType"/> values are not the same. </summary>
        public static bool operator !=(DeadLetterEndPointType left, DeadLetterEndPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeadLetterEndPointType"/>. </summary>
        public static implicit operator DeadLetterEndPointType(string value) => new DeadLetterEndPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeadLetterEndPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeadLetterEndPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
