// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Data Residency Boundary of the resource. </summary>
    public readonly partial struct DataResidencyBoundary : IEquatable<DataResidencyBoundary>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataResidencyBoundary"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataResidencyBoundary(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WithinGeopairValue = "WithinGeopair";
        private const string WithinRegionValue = "WithinRegion";

        /// <summary> WithinGeopair. </summary>
        public static DataResidencyBoundary WithinGeopair { get; } = new DataResidencyBoundary(WithinGeopairValue);
        /// <summary> WithinRegion. </summary>
        public static DataResidencyBoundary WithinRegion { get; } = new DataResidencyBoundary(WithinRegionValue);
        /// <summary> Determines if two <see cref="DataResidencyBoundary"/> values are the same. </summary>
        public static bool operator ==(DataResidencyBoundary left, DataResidencyBoundary right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataResidencyBoundary"/> values are not the same. </summary>
        public static bool operator !=(DataResidencyBoundary left, DataResidencyBoundary right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataResidencyBoundary"/>. </summary>
        public static implicit operator DataResidencyBoundary(string value) => new DataResidencyBoundary(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataResidencyBoundary other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataResidencyBoundary other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
