// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Custom JWT authentication settings for namespace resource. </summary>
    public partial class CustomJwtAuthenticationSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomJwtAuthenticationSettings"/>. </summary>
        public CustomJwtAuthenticationSettings()
        {
            IssuerCertificates = new ChangeTrackingList<IssuerCertificateInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="CustomJwtAuthenticationSettings"/>. </summary>
        /// <param name="tokenIssuer"> Expected JWT token issuer. </param>
        /// <param name="issuerCertificates"> Information about the certificate that is used for token validation. We currently support maximum 2 certificates. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomJwtAuthenticationSettings(string tokenIssuer, IList<IssuerCertificateInfo> issuerCertificates, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TokenIssuer = tokenIssuer;
            IssuerCertificates = issuerCertificates;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Expected JWT token issuer. </summary>
        [WirePath("tokenIssuer")]
        public string TokenIssuer { get; set; }
        /// <summary> Information about the certificate that is used for token validation. We currently support maximum 2 certificates. </summary>
        [WirePath("issuerCertificates")]
        public IList<IssuerCertificateInfo> IssuerCertificates { get; }
    }
}
