// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    public partial class CustomJwtAuthenticationSettings : IUtf8JsonSerializable, IJsonModel<CustomJwtAuthenticationSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CustomJwtAuthenticationSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CustomJwtAuthenticationSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomJwtAuthenticationSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomJwtAuthenticationSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TokenIssuer))
            {
                writer.WritePropertyName("tokenIssuer"u8);
                writer.WriteStringValue(TokenIssuer);
            }
            if (Optional.IsCollectionDefined(IssuerCertificates))
            {
                writer.WritePropertyName("issuerCertificates"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerCertificates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CustomJwtAuthenticationSettings IJsonModel<CustomJwtAuthenticationSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomJwtAuthenticationSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomJwtAuthenticationSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCustomJwtAuthenticationSettings(document.RootElement, options);
        }

        internal static CustomJwtAuthenticationSettings DeserializeCustomJwtAuthenticationSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string tokenIssuer = default;
            IList<IssuerCertificateInfo> issuerCertificates = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tokenIssuer"u8))
                {
                    tokenIssuer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("issuerCertificates"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IssuerCertificateInfo> array = new List<IssuerCertificateInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IssuerCertificateInfo.DeserializeIssuerCertificateInfo(item, options));
                    }
                    issuerCertificates = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CustomJwtAuthenticationSettings(tokenIssuer, issuerCertificates ?? new ChangeTrackingList<IssuerCertificateInfo>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TokenIssuer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tokenIssuer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TokenIssuer))
                {
                    builder.Append("  tokenIssuer: ");
                    if (TokenIssuer.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TokenIssuer}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TokenIssuer}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IssuerCertificates), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  issuerCertificates: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(IssuerCertificates))
                {
                    if (IssuerCertificates.Any())
                    {
                        builder.Append("  issuerCertificates: ");
                        builder.AppendLine("[");
                        foreach (var item in IssuerCertificates)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  issuerCertificates: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CustomJwtAuthenticationSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomJwtAuthenticationSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CustomJwtAuthenticationSettings)} does not support writing '{options.Format}' format.");
            }
        }

        CustomJwtAuthenticationSettings IPersistableModel<CustomJwtAuthenticationSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomJwtAuthenticationSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCustomJwtAuthenticationSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CustomJwtAuthenticationSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CustomJwtAuthenticationSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
