// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'. </summary>
    public readonly partial struct CustomJwtAuthenticationManagedIdentityType : IEquatable<CustomJwtAuthenticationManagedIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CustomJwtAuthenticationManagedIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CustomJwtAuthenticationManagedIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemAssignedValue = "SystemAssigned";
        private const string UserAssignedValue = "UserAssigned";

        /// <summary> SystemAssigned. </summary>
        public static CustomJwtAuthenticationManagedIdentityType SystemAssigned { get; } = new CustomJwtAuthenticationManagedIdentityType(SystemAssignedValue);
        /// <summary> UserAssigned. </summary>
        public static CustomJwtAuthenticationManagedIdentityType UserAssigned { get; } = new CustomJwtAuthenticationManagedIdentityType(UserAssignedValue);
        /// <summary> Determines if two <see cref="CustomJwtAuthenticationManagedIdentityType"/> values are the same. </summary>
        public static bool operator ==(CustomJwtAuthenticationManagedIdentityType left, CustomJwtAuthenticationManagedIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CustomJwtAuthenticationManagedIdentityType"/> values are not the same. </summary>
        public static bool operator !=(CustomJwtAuthenticationManagedIdentityType left, CustomJwtAuthenticationManagedIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CustomJwtAuthenticationManagedIdentityType"/>. </summary>
        public static implicit operator CustomJwtAuthenticationManagedIdentityType(string value) => new CustomJwtAuthenticationManagedIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CustomJwtAuthenticationManagedIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CustomJwtAuthenticationManagedIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
