// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Validation state for the custom domain. This is a read only property and is initially set to 'Pending' and will be updated to 'Approved' by Event Grid only after ownership of the domain name has been successfully validated. </summary>
    public readonly partial struct CustomDomainValidationState : IEquatable<CustomDomainValidationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CustomDomainValidationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CustomDomainValidationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string ErrorRetrievingDnsRecordValue = "ErrorRetrievingDnsRecord";

        /// <summary> Pending. </summary>
        public static CustomDomainValidationState Pending { get; } = new CustomDomainValidationState(PendingValue);
        /// <summary> Approved. </summary>
        public static CustomDomainValidationState Approved { get; } = new CustomDomainValidationState(ApprovedValue);
        /// <summary> ErrorRetrievingDnsRecord. </summary>
        public static CustomDomainValidationState ErrorRetrievingDnsRecord { get; } = new CustomDomainValidationState(ErrorRetrievingDnsRecordValue);
        /// <summary> Determines if two <see cref="CustomDomainValidationState"/> values are the same. </summary>
        public static bool operator ==(CustomDomainValidationState left, CustomDomainValidationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CustomDomainValidationState"/> values are not the same. </summary>
        public static bool operator !=(CustomDomainValidationState left, CustomDomainValidationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CustomDomainValidationState"/>. </summary>
        public static implicit operator CustomDomainValidationState(string value) => new CustomDomainValidationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CustomDomainValidationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CustomDomainValidationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
