// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    public partial class CustomDomainOwnershipValidationResult : IUtf8JsonSerializable, IJsonModel<CustomDomainOwnershipValidationResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CustomDomainOwnershipValidationResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CustomDomainOwnershipValidationResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainOwnershipValidationResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomDomainOwnershipValidationResult)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(CustomDomainsForTopicsConfiguration))
            {
                writer.WritePropertyName("customDomainsForTopicsConfiguration"u8);
                writer.WriteStartArray();
                foreach (var item in CustomDomainsForTopicsConfiguration)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CustomDomainsForTopicSpacesConfiguration))
            {
                writer.WritePropertyName("customDomainsForTopicSpacesConfiguration"u8);
                writer.WriteStartArray();
                foreach (var item in CustomDomainsForTopicSpacesConfiguration)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CustomDomainOwnershipValidationResult IJsonModel<CustomDomainOwnershipValidationResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainOwnershipValidationResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomDomainOwnershipValidationResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCustomDomainOwnershipValidationResult(document.RootElement, options);
        }

        internal static CustomDomainOwnershipValidationResult DeserializeCustomDomainOwnershipValidationResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<CustomDomainConfiguration> customDomainsForTopicsConfiguration = default;
            IReadOnlyList<CustomDomainConfiguration> customDomainsForTopicSpacesConfiguration = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("customDomainsForTopicsConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CustomDomainConfiguration> array = new List<CustomDomainConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CustomDomainConfiguration.DeserializeCustomDomainConfiguration(item, options));
                    }
                    customDomainsForTopicsConfiguration = array;
                    continue;
                }
                if (property.NameEquals("customDomainsForTopicSpacesConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CustomDomainConfiguration> array = new List<CustomDomainConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CustomDomainConfiguration.DeserializeCustomDomainConfiguration(item, options));
                    }
                    customDomainsForTopicSpacesConfiguration = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CustomDomainOwnershipValidationResult(customDomainsForTopicsConfiguration ?? new ChangeTrackingList<CustomDomainConfiguration>(), customDomainsForTopicSpacesConfiguration ?? new ChangeTrackingList<CustomDomainConfiguration>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomDomainsForTopicsConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customDomainsForTopicsConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CustomDomainsForTopicsConfiguration))
                {
                    if (CustomDomainsForTopicsConfiguration.Any())
                    {
                        builder.Append("  customDomainsForTopicsConfiguration: ");
                        builder.AppendLine("[");
                        foreach (var item in CustomDomainsForTopicsConfiguration)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  customDomainsForTopicsConfiguration: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomDomainsForTopicSpacesConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customDomainsForTopicSpacesConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CustomDomainsForTopicSpacesConfiguration))
                {
                    if (CustomDomainsForTopicSpacesConfiguration.Any())
                    {
                        builder.Append("  customDomainsForTopicSpacesConfiguration: ");
                        builder.AppendLine("[");
                        foreach (var item in CustomDomainsForTopicSpacesConfiguration)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  customDomainsForTopicSpacesConfiguration: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CustomDomainOwnershipValidationResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainOwnershipValidationResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CustomDomainOwnershipValidationResult)} does not support writing '{options.Format}' format.");
            }
        }

        CustomDomainOwnershipValidationResult IPersistableModel<CustomDomainOwnershipValidationResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainOwnershipValidationResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCustomDomainOwnershipValidationResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CustomDomainOwnershipValidationResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CustomDomainOwnershipValidationResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
