// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'. </summary>
    public readonly partial struct CustomDomainIdentityType : IEquatable<CustomDomainIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CustomDomainIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CustomDomainIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemAssignedValue = "SystemAssigned";
        private const string UserAssignedValue = "UserAssigned";

        /// <summary> SystemAssigned. </summary>
        public static CustomDomainIdentityType SystemAssigned { get; } = new CustomDomainIdentityType(SystemAssignedValue);
        /// <summary> UserAssigned. </summary>
        public static CustomDomainIdentityType UserAssigned { get; } = new CustomDomainIdentityType(UserAssignedValue);
        /// <summary> Determines if two <see cref="CustomDomainIdentityType"/> values are the same. </summary>
        public static bool operator ==(CustomDomainIdentityType left, CustomDomainIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CustomDomainIdentityType"/> values are not the same. </summary>
        public static bool operator !=(CustomDomainIdentityType left, CustomDomainIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CustomDomainIdentityType"/>. </summary>
        public static implicit operator CustomDomainIdentityType(string value) => new CustomDomainIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CustomDomainIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CustomDomainIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
