// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    public partial class CustomDomainConfiguration : IUtf8JsonSerializable, IJsonModel<CustomDomainConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CustomDomainConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CustomDomainConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomDomainConfiguration)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("fullyQualifiedDomainName"u8);
            writer.WriteStringValue(FullyQualifiedDomainName);
            if (Optional.IsDefined(ValidationState))
            {
                writer.WritePropertyName("validationState"u8);
                writer.WriteStringValue(ValidationState.Value.ToString());
            }
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                writer.WriteObjectValue(Identity, options);
            }
            if (Optional.IsDefined(CertificateUri))
            {
                writer.WritePropertyName("certificateUrl"u8);
                writer.WriteStringValue(CertificateUri.AbsoluteUri);
            }
            if (Optional.IsDefined(ExpectedTxtRecordName))
            {
                writer.WritePropertyName("expectedTxtRecordName"u8);
                writer.WriteStringValue(ExpectedTxtRecordName);
            }
            if (Optional.IsDefined(ExpectedTxtRecordValue))
            {
                writer.WritePropertyName("expectedTxtRecordValue"u8);
                writer.WriteStringValue(ExpectedTxtRecordValue);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CustomDomainConfiguration IJsonModel<CustomDomainConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomDomainConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCustomDomainConfiguration(document.RootElement, options);
        }

        internal static CustomDomainConfiguration DeserializeCustomDomainConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string fullyQualifiedDomainName = default;
            CustomDomainValidationState? validationState = default;
            CustomDomainIdentity identity = default;
            Uri certificateUri = default;
            string expectedTxtRecordName = default;
            string expectedTxtRecordValue = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("fullyQualifiedDomainName"u8))
                {
                    fullyQualifiedDomainName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("validationState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    validationState = new CustomDomainValidationState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = CustomDomainIdentity.DeserializeCustomDomainIdentity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("certificateUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    certificateUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("expectedTxtRecordName"u8))
                {
                    expectedTxtRecordName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("expectedTxtRecordValue"u8))
                {
                    expectedTxtRecordValue = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CustomDomainConfiguration(
                fullyQualifiedDomainName,
                validationState,
                identity,
                certificateUri,
                expectedTxtRecordName,
                expectedTxtRecordValue,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FullyQualifiedDomainName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fullyQualifiedDomainName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FullyQualifiedDomainName))
                {
                    builder.Append("  fullyQualifiedDomainName: ");
                    if (FullyQualifiedDomainName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{FullyQualifiedDomainName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{FullyQualifiedDomainName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidationState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  validationState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidationState))
                {
                    builder.Append("  validationState: ");
                    builder.AppendLine($"'{ValidationState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Identity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Identity))
                {
                    builder.Append("  identity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Identity, options, 2, false, "  identity: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CertificateUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  certificateUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CertificateUri))
                {
                    builder.Append("  certificateUrl: ");
                    builder.AppendLine($"'{CertificateUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExpectedTxtRecordName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  expectedTxtRecordName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExpectedTxtRecordName))
                {
                    builder.Append("  expectedTxtRecordName: ");
                    if (ExpectedTxtRecordName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ExpectedTxtRecordName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ExpectedTxtRecordName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExpectedTxtRecordValue), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  expectedTxtRecordValue: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExpectedTxtRecordValue))
                {
                    builder.Append("  expectedTxtRecordValue: ");
                    if (ExpectedTxtRecordValue.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ExpectedTxtRecordValue}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ExpectedTxtRecordValue}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CustomDomainConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CustomDomainConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        CustomDomainConfiguration IPersistableModel<CustomDomainConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomDomainConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCustomDomainConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CustomDomainConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CustomDomainConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
