// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Provisioning state of the ClientGroup resource. </summary>
    public readonly partial struct ClientGroupProvisioningState : IEquatable<ClientGroupProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClientGroupProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClientGroupProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string DeletedValue = "Deleted";

        /// <summary> Creating. </summary>
        public static ClientGroupProvisioningState Creating { get; } = new ClientGroupProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static ClientGroupProvisioningState Updating { get; } = new ClientGroupProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static ClientGroupProvisioningState Deleting { get; } = new ClientGroupProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static ClientGroupProvisioningState Succeeded { get; } = new ClientGroupProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static ClientGroupProvisioningState Canceled { get; } = new ClientGroupProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static ClientGroupProvisioningState Failed { get; } = new ClientGroupProvisioningState(FailedValue);
        /// <summary> Deleted. </summary>
        public static ClientGroupProvisioningState Deleted { get; } = new ClientGroupProvisioningState(DeletedValue);
        /// <summary> Determines if two <see cref="ClientGroupProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ClientGroupProvisioningState left, ClientGroupProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClientGroupProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ClientGroupProvisioningState left, ClientGroupProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClientGroupProvisioningState"/>. </summary>
        public static implicit operator ClientGroupProvisioningState(string value) => new ClientGroupProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClientGroupProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClientGroupProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
