// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid.Models
{
    [PersistableModelProxy(typeof(UnknownAdvancedFilter))]
    public partial class AdvancedFilter : IUtf8JsonSerializable, IJsonModel<AdvancedFilter>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AdvancedFilter>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AdvancedFilter>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdvancedFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdvancedFilter)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("operatorType"u8);
            writer.WriteStringValue(OperatorType.ToString());
            if (Optional.IsDefined(Key))
            {
                writer.WritePropertyName("key"u8);
                writer.WriteStringValue(Key);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AdvancedFilter IJsonModel<AdvancedFilter>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdvancedFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdvancedFilter)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAdvancedFilter(document.RootElement, options);
        }

        internal static AdvancedFilter DeserializeAdvancedFilter(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("operatorType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "BoolEquals": return BoolEqualsAdvancedFilter.DeserializeBoolEqualsAdvancedFilter(element, options);
                    case "IsNotNull": return IsNotNullAdvancedFilter.DeserializeIsNotNullAdvancedFilter(element, options);
                    case "IsNullOrUndefined": return IsNullOrUndefinedAdvancedFilter.DeserializeIsNullOrUndefinedAdvancedFilter(element, options);
                    case "NumberGreaterThan": return NumberGreaterThanAdvancedFilter.DeserializeNumberGreaterThanAdvancedFilter(element, options);
                    case "NumberGreaterThanOrEquals": return NumberGreaterThanOrEqualsAdvancedFilter.DeserializeNumberGreaterThanOrEqualsAdvancedFilter(element, options);
                    case "NumberIn": return NumberInAdvancedFilter.DeserializeNumberInAdvancedFilter(element, options);
                    case "NumberInRange": return NumberInRangeAdvancedFilter.DeserializeNumberInRangeAdvancedFilter(element, options);
                    case "NumberLessThan": return NumberLessThanAdvancedFilter.DeserializeNumberLessThanAdvancedFilter(element, options);
                    case "NumberLessThanOrEquals": return NumberLessThanOrEqualsAdvancedFilter.DeserializeNumberLessThanOrEqualsAdvancedFilter(element, options);
                    case "NumberNotIn": return NumberNotInAdvancedFilter.DeserializeNumberNotInAdvancedFilter(element, options);
                    case "NumberNotInRange": return NumberNotInRangeAdvancedFilter.DeserializeNumberNotInRangeAdvancedFilter(element, options);
                    case "StringBeginsWith": return StringBeginsWithAdvancedFilter.DeserializeStringBeginsWithAdvancedFilter(element, options);
                    case "StringContains": return StringContainsAdvancedFilter.DeserializeStringContainsAdvancedFilter(element, options);
                    case "StringEndsWith": return StringEndsWithAdvancedFilter.DeserializeStringEndsWithAdvancedFilter(element, options);
                    case "StringIn": return StringInAdvancedFilter.DeserializeStringInAdvancedFilter(element, options);
                    case "StringNotBeginsWith": return StringNotBeginsWithAdvancedFilter.DeserializeStringNotBeginsWithAdvancedFilter(element, options);
                    case "StringNotContains": return StringNotContainsAdvancedFilter.DeserializeStringNotContainsAdvancedFilter(element, options);
                    case "StringNotEndsWith": return StringNotEndsWithAdvancedFilter.DeserializeStringNotEndsWithAdvancedFilter(element, options);
                    case "StringNotIn": return StringNotInAdvancedFilter.DeserializeStringNotInAdvancedFilter(element, options);
                }
            }
            return UnknownAdvancedFilter.DeserializeUnknownAdvancedFilter(element, options);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperatorType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  operatorType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  operatorType: ");
                builder.AppendLine($"'{OperatorType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Key), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  key: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Key))
                {
                    builder.Append("  key: ");
                    if (Key.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Key}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Key}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<AdvancedFilter>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdvancedFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(AdvancedFilter)} does not support writing '{options.Format}' format.");
            }
        }

        AdvancedFilter IPersistableModel<AdvancedFilter>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdvancedFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAdvancedFilter(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AdvancedFilter)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AdvancedFilter>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
