// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class TopicSpaceOperationSource : IOperationSource<TopicSpaceResource>
    {
        private readonly ArmClient _client;

        internal TopicSpaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        TopicSpaceResource IOperationSource<TopicSpaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = TopicSpaceData.DeserializeTopicSpaceData(document.RootElement);
            return new TopicSpaceResource(_client, data);
        }

        async ValueTask<TopicSpaceResource> IOperationSource<TopicSpaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = TopicSpaceData.DeserializeTopicSpaceData(document.RootElement);
            return new TopicSpaceResource(_client, data);
        }
    }
}
