// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class SystemTopicOperationSource : IOperationSource<SystemTopicResource>
    {
        private readonly ArmClient _client;

        internal SystemTopicOperationSource(ArmClient client)
        {
            _client = client;
        }

        SystemTopicResource IOperationSource<SystemTopicResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SystemTopicData.DeserializeSystemTopicData(document.RootElement);
            return new SystemTopicResource(_client, data);
        }

        async ValueTask<SystemTopicResource> IOperationSource<SystemTopicResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SystemTopicData.DeserializeSystemTopicData(document.RootElement);
            return new SystemTopicResource(_client, data);
        }
    }
}
