// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class PartnerRegistrationOperationSource : IOperationSource<PartnerRegistrationResource>
    {
        private readonly ArmClient _client;

        internal PartnerRegistrationOperationSource(ArmClient client)
        {
            _client = client;
        }

        PartnerRegistrationResource IOperationSource<PartnerRegistrationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PartnerRegistrationData.DeserializePartnerRegistrationData(document.RootElement);
            return new PartnerRegistrationResource(_client, data);
        }

        async ValueTask<PartnerRegistrationResource> IOperationSource<PartnerRegistrationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PartnerRegistrationData.DeserializePartnerRegistrationData(document.RootElement);
            return new PartnerRegistrationResource(_client, data);
        }
    }
}
