// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class PartnerNamespaceOperationSource : IOperationSource<PartnerNamespaceResource>
    {
        private readonly ArmClient _client;

        internal PartnerNamespaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        PartnerNamespaceResource IOperationSource<PartnerNamespaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PartnerNamespaceData.DeserializePartnerNamespaceData(document.RootElement);
            return new PartnerNamespaceResource(_client, data);
        }

        async ValueTask<PartnerNamespaceResource> IOperationSource<PartnerNamespaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PartnerNamespaceData.DeserializePartnerNamespaceData(document.RootElement);
            return new PartnerNamespaceResource(_client, data);
        }
    }
}
