// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class PartnerDestinationOperationSource : IOperationSource<PartnerDestinationResource>
    {
        private readonly ArmClient _client;

        internal PartnerDestinationOperationSource(ArmClient client)
        {
            _client = client;
        }

        PartnerDestinationResource IOperationSource<PartnerDestinationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PartnerDestinationData.DeserializePartnerDestinationData(document.RootElement);
            return new PartnerDestinationResource(_client, data);
        }

        async ValueTask<PartnerDestinationResource> IOperationSource<PartnerDestinationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PartnerDestinationData.DeserializePartnerDestinationData(document.RootElement);
            return new PartnerDestinationResource(_client, data);
        }
    }
}
