// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class EventGridPartnerNamespacePrivateEndpointConnectionOperationSource : IOperationSource<EventGridPartnerNamespacePrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal EventGridPartnerNamespacePrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        EventGridPartnerNamespacePrivateEndpointConnectionResource IOperationSource<EventGridPartnerNamespacePrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EventGridPrivateEndpointConnectionData.DeserializeEventGridPrivateEndpointConnectionData(document.RootElement);
            return new EventGridPartnerNamespacePrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<EventGridPartnerNamespacePrivateEndpointConnectionResource> IOperationSource<EventGridPartnerNamespacePrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EventGridPrivateEndpointConnectionData.DeserializeEventGridPrivateEndpointConnectionData(document.RootElement);
            return new EventGridPartnerNamespacePrivateEndpointConnectionResource(_client, data);
        }
    }
}
