// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class EventGridNamespaceClientOperationSource : IOperationSource<EventGridNamespaceClientResource>
    {
        private readonly ArmClient _client;

        internal EventGridNamespaceClientOperationSource(ArmClient client)
        {
            _client = client;
        }

        EventGridNamespaceClientResource IOperationSource<EventGridNamespaceClientResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EventGridNamespaceClientData.DeserializeEventGridNamespaceClientData(document.RootElement);
            return new EventGridNamespaceClientResource(_client, data);
        }

        async ValueTask<EventGridNamespaceClientResource> IOperationSource<EventGridNamespaceClientResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EventGridNamespaceClientData.DeserializeEventGridNamespaceClientData(document.RootElement);
            return new EventGridNamespaceClientResource(_client, data);
        }
    }
}
