// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class EventGridNamespaceClientGroupOperationSource : IOperationSource<EventGridNamespaceClientGroupResource>
    {
        private readonly ArmClient _client;

        internal EventGridNamespaceClientGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        EventGridNamespaceClientGroupResource IOperationSource<EventGridNamespaceClientGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EventGridNamespaceClientGroupData.DeserializeEventGridNamespaceClientGroupData(document.RootElement);
            return new EventGridNamespaceClientGroupResource(_client, data);
        }

        async ValueTask<EventGridNamespaceClientGroupResource> IOperationSource<EventGridNamespaceClientGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EventGridNamespaceClientGroupData.DeserializeEventGridNamespaceClientGroupData(document.RootElement);
            return new EventGridNamespaceClientGroupResource(_client, data);
        }
    }
}
