// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class DomainTopicOperationSource : IOperationSource<DomainTopicResource>
    {
        private readonly ArmClient _client;

        internal DomainTopicOperationSource(ArmClient client)
        {
            _client = client;
        }

        DomainTopicResource IOperationSource<DomainTopicResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DomainTopicData.DeserializeDomainTopicData(document.RootElement);
            return new DomainTopicResource(_client, data);
        }

        async ValueTask<DomainTopicResource> IOperationSource<DomainTopicResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DomainTopicData.DeserializeDomainTopicData(document.RootElement);
            return new DomainTopicResource(_client, data);
        }
    }
}
