// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class DomainNetworkSecurityPerimeterConfigurationOperationSource : IOperationSource<DomainNetworkSecurityPerimeterConfigurationResource>
    {
        private readonly ArmClient _client;

        internal DomainNetworkSecurityPerimeterConfigurationOperationSource(ArmClient client)
        {
            _client = client;
        }

        DomainNetworkSecurityPerimeterConfigurationResource IOperationSource<DomainNetworkSecurityPerimeterConfigurationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetworkSecurityPerimeterConfigurationData.DeserializeNetworkSecurityPerimeterConfigurationData(document.RootElement);
            return new DomainNetworkSecurityPerimeterConfigurationResource(_client, data);
        }

        async ValueTask<DomainNetworkSecurityPerimeterConfigurationResource> IOperationSource<DomainNetworkSecurityPerimeterConfigurationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetworkSecurityPerimeterConfigurationData.DeserializeNetworkSecurityPerimeterConfigurationData(document.RootElement);
            return new DomainNetworkSecurityPerimeterConfigurationResource(_client, data);
        }
    }
}
