// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EventGrid
{
    internal class CaCertificateOperationSource : IOperationSource<CaCertificateResource>
    {
        private readonly ArmClient _client;

        internal CaCertificateOperationSource(ArmClient client)
        {
            _client = client;
        }

        CaCertificateResource IOperationSource<CaCertificateResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CaCertificateData.DeserializeCaCertificateData(document.RootElement);
            return new CaCertificateResource(_client, data);
        }

        async ValueTask<CaCertificateResource> IOperationSource<CaCertificateResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CaCertificateData.DeserializeCaCertificateData(document.RootElement);
            return new CaCertificateResource(_client, data);
        }
    }
}
