// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.EventGrid.Models;

namespace Azure.ResourceManager.EventGrid.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableEventGridResourceGroupResource : ArmResource
    {
        private ClientDiagnostics _eventSubscriptionClientDiagnostics;
        private EventSubscriptionsRestOperations _eventSubscriptionRestClient;
        private ClientDiagnostics _eventGridTopicTopicsClientDiagnostics;
        private TopicsRestOperations _eventGridTopicTopicsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableEventGridResourceGroupResource"/> class for mocking. </summary>
        protected MockableEventGridResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableEventGridResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableEventGridResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics EventSubscriptionClientDiagnostics => _eventSubscriptionClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.EventGrid", EventSubscriptionResource.ResourceType.Namespace, Diagnostics);
        private EventSubscriptionsRestOperations EventSubscriptionRestClient => _eventSubscriptionRestClient ??= new EventSubscriptionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(EventSubscriptionResource.ResourceType));
        private ClientDiagnostics EventGridTopicTopicsClientDiagnostics => _eventGridTopicTopicsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.EventGrid", EventGridTopicResource.ResourceType.Namespace, Diagnostics);
        private TopicsRestOperations EventGridTopicTopicsRestClient => _eventGridTopicTopicsRestClient ??= new TopicsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(EventGridTopicResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of EventGridDomainResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of EventGridDomainResources and their operations over a EventGridDomainResource. </returns>
        public virtual EventGridDomainCollection GetEventGridDomains()
        {
            return GetCachedClient(client => new EventGridDomainCollection(client, Id));
        }

        /// <summary>
        /// Get properties of a domain.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Domains_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EventGridDomainResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="domainName"> Name of the domain. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="domainName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="domainName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<EventGridDomainResource>> GetEventGridDomainAsync(string domainName, CancellationToken cancellationToken = default)
        {
            return await GetEventGridDomains().GetAsync(domainName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get properties of a domain.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Domains_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EventGridDomainResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="domainName"> Name of the domain. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="domainName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="domainName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<EventGridDomainResource> GetEventGridDomain(string domainName, CancellationToken cancellationToken = default)
        {
            return GetEventGridDomains().Get(domainName, cancellationToken);
        }

        /// <summary> Gets a collection of EventGridNamespaceResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of EventGridNamespaceResources and their operations over a EventGridNamespaceResource. </returns>
        public virtual EventGridNamespaceCollection GetEventGridNamespaces()
        {
            return GetCachedClient(client => new EventGridNamespaceCollection(client, Id));
        }

        /// <summary>
        /// Get properties of a namespace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Namespaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EventGridNamespaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namespaceName"> Name of the namespace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="namespaceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="namespaceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<EventGridNamespaceResource>> GetEventGridNamespaceAsync(string namespaceName, CancellationToken cancellationToken = default)
        {
            return await GetEventGridNamespaces().GetAsync(namespaceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get properties of a namespace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Namespaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EventGridNamespaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namespaceName"> Name of the namespace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="namespaceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="namespaceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<EventGridNamespaceResource> GetEventGridNamespace(string namespaceName, CancellationToken cancellationToken = default)
        {
            return GetEventGridNamespaces().Get(namespaceName, cancellationToken);
        }

        /// <summary> Gets an object representing a PartnerConfigurationResource along with the instance operations that can be performed on it in the ResourceGroupResource. </summary>
        /// <returns> Returns a <see cref="PartnerConfigurationResource"/> object. </returns>
        public virtual PartnerConfigurationResource GetPartnerConfiguration()
        {
            return new PartnerConfigurationResource(Client, Id.AppendProviderResource("Microsoft.EventGrid", "partnerConfigurations", "default"));
        }

        /// <summary> Gets a collection of PartnerDestinationResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of PartnerDestinationResources and their operations over a PartnerDestinationResource. </returns>
        public virtual PartnerDestinationCollection GetPartnerDestinations()
        {
            return GetCachedClient(client => new PartnerDestinationCollection(client, Id));
        }

        /// <summary>
        /// Get properties of a partner destination.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerDestinations/{partnerDestinationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerDestinations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerDestinationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerDestinationName"> Name of the partner destination. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerDestinationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerDestinationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<PartnerDestinationResource>> GetPartnerDestinationAsync(string partnerDestinationName, CancellationToken cancellationToken = default)
        {
            return await GetPartnerDestinations().GetAsync(partnerDestinationName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get properties of a partner destination.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerDestinations/{partnerDestinationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerDestinations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerDestinationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerDestinationName"> Name of the partner destination. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerDestinationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerDestinationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<PartnerDestinationResource> GetPartnerDestination(string partnerDestinationName, CancellationToken cancellationToken = default)
        {
            return GetPartnerDestinations().Get(partnerDestinationName, cancellationToken);
        }

        /// <summary> Gets a collection of PartnerNamespaceResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of PartnerNamespaceResources and their operations over a PartnerNamespaceResource. </returns>
        public virtual PartnerNamespaceCollection GetPartnerNamespaces()
        {
            return GetCachedClient(client => new PartnerNamespaceCollection(client, Id));
        }

        /// <summary>
        /// Get properties of a partner namespace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerNamespaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerNamespaceName"> Name of the partner namespace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerNamespaceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerNamespaceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<PartnerNamespaceResource>> GetPartnerNamespaceAsync(string partnerNamespaceName, CancellationToken cancellationToken = default)
        {
            return await GetPartnerNamespaces().GetAsync(partnerNamespaceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get properties of a partner namespace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerNamespaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerNamespaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerNamespaceName"> Name of the partner namespace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerNamespaceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerNamespaceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<PartnerNamespaceResource> GetPartnerNamespace(string partnerNamespaceName, CancellationToken cancellationToken = default)
        {
            return GetPartnerNamespaces().Get(partnerNamespaceName, cancellationToken);
        }

        /// <summary> Gets a collection of PartnerRegistrationResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of PartnerRegistrationResources and their operations over a PartnerRegistrationResource. </returns>
        public virtual PartnerRegistrationCollection GetPartnerRegistrations()
        {
            return GetCachedClient(client => new PartnerRegistrationCollection(client, Id));
        }

        /// <summary>
        /// Gets a partner registration with the specified parameters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerRegistrations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerRegistrationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerRegistrationName"> Name of the partner registration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerRegistrationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerRegistrationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<PartnerRegistrationResource>> GetPartnerRegistrationAsync(string partnerRegistrationName, CancellationToken cancellationToken = default)
        {
            return await GetPartnerRegistrations().GetAsync(partnerRegistrationName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a partner registration with the specified parameters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerRegistrations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerRegistrationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerRegistrationName"> Name of the partner registration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerRegistrationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerRegistrationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<PartnerRegistrationResource> GetPartnerRegistration(string partnerRegistrationName, CancellationToken cancellationToken = default)
        {
            return GetPartnerRegistrations().Get(partnerRegistrationName, cancellationToken);
        }

        /// <summary> Gets a collection of PartnerTopicResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of PartnerTopicResources and their operations over a PartnerTopicResource. </returns>
        public virtual PartnerTopicCollection GetPartnerTopics()
        {
            return GetCachedClient(client => new PartnerTopicCollection(client, Id));
        }

        /// <summary>
        /// Get properties of a partner topic.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerTopics/{partnerTopicName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerTopics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerTopicResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerTopicName"> Name of the partner topic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerTopicName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerTopicName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<PartnerTopicResource>> GetPartnerTopicAsync(string partnerTopicName, CancellationToken cancellationToken = default)
        {
            return await GetPartnerTopics().GetAsync(partnerTopicName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get properties of a partner topic.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerTopics/{partnerTopicName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PartnerTopics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PartnerTopicResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="partnerTopicName"> Name of the partner topic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="partnerTopicName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="partnerTopicName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<PartnerTopicResource> GetPartnerTopic(string partnerTopicName, CancellationToken cancellationToken = default)
        {
            return GetPartnerTopics().Get(partnerTopicName, cancellationToken);
        }

        /// <summary> Gets a collection of SystemTopicResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of SystemTopicResources and their operations over a SystemTopicResource. </returns>
        public virtual SystemTopicCollection GetSystemTopics()
        {
            return GetCachedClient(client => new SystemTopicCollection(client, Id));
        }

        /// <summary>
        /// Get properties of a system topic.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/systemTopics/{systemTopicName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemTopics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SystemTopicResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemTopicName"> Name of the system topic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="systemTopicName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="systemTopicName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SystemTopicResource>> GetSystemTopicAsync(string systemTopicName, CancellationToken cancellationToken = default)
        {
            return await GetSystemTopics().GetAsync(systemTopicName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get properties of a system topic.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/systemTopics/{systemTopicName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemTopics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SystemTopicResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemTopicName"> Name of the system topic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="systemTopicName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="systemTopicName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SystemTopicResource> GetSystemTopic(string systemTopicName, CancellationToken cancellationToken = default)
        {
            return GetSystemTopics().Get(systemTopicName, cancellationToken);
        }

        /// <summary> Gets a collection of EventGridTopicResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of EventGridTopicResources and their operations over a EventGridTopicResource. </returns>
        public virtual EventGridTopicCollection GetEventGridTopics()
        {
            return GetCachedClient(client => new EventGridTopicCollection(client, Id));
        }

        /// <summary>
        /// Get properties of a topic.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Topics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EventGridTopicResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="topicName"> Name of the topic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="topicName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<EventGridTopicResource>> GetEventGridTopicAsync(string topicName, CancellationToken cancellationToken = default)
        {
            return await GetEventGridTopics().GetAsync(topicName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get properties of a topic.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Topics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EventGridTopicResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="topicName"> Name of the topic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="topicName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<EventGridTopicResource> GetEventGridTopic(string topicName, CancellationToken cancellationToken = default)
        {
            return GetEventGridTopics().Get(topicName, cancellationToken);
        }
    }
}
