// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventGrid.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventGrid
{
    /// <summary>
    /// A class representing the EventGridNamespacePermissionBinding data model.
    /// The Permission binding resource.
    /// </summary>
    public partial class EventGridNamespacePermissionBindingData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventGridNamespacePermissionBindingData"/>. </summary>
        public EventGridNamespacePermissionBindingData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventGridNamespacePermissionBindingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description for the Permission Binding resource. </param>
        /// <param name="topicSpaceName">
        /// The name of the Topic Space resource that the permission is bound to.
        /// The Topic space needs to be a resource under the same namespace the permission binding is a part of.
        /// </param>
        /// <param name="permission"> The allowed permission. </param>
        /// <param name="clientGroupName">
        /// The name of the client group resource that the permission is bound to.
        /// The client group needs to be a resource under the same namespace the permission binding is a part of.
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the PermissionBinding resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventGridNamespacePermissionBindingData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, string topicSpaceName, PermissionType? permission, string clientGroupName, PermissionBindingProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            TopicSpaceName = topicSpaceName;
            Permission = permission;
            ClientGroupName = clientGroupName;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Description for the Permission Binding resource. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary>
        /// The name of the Topic Space resource that the permission is bound to.
        /// The Topic space needs to be a resource under the same namespace the permission binding is a part of.
        /// </summary>
        [WirePath("properties.topicSpaceName")]
        public string TopicSpaceName { get; set; }
        /// <summary> The allowed permission. </summary>
        [WirePath("properties.permission")]
        public PermissionType? Permission { get; set; }
        /// <summary>
        /// The name of the client group resource that the permission is bound to.
        /// The client group needs to be a resource under the same namespace the permission binding is a part of.
        /// </summary>
        [WirePath("properties.clientGroupName")]
        public string ClientGroupName { get; set; }
        /// <summary> Provisioning state of the PermissionBinding resource. </summary>
        [WirePath("properties.provisioningState")]
        public PermissionBindingProvisioningState? ProvisioningState { get; }
    }
}
