// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EventGrid.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EventGrid
{
    /// <summary>
    /// A class representing the EventGridNamespaceClientGroup data model.
    /// The Client group resource.
    /// </summary>
    public partial class EventGridNamespaceClientGroupData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EventGridNamespaceClientGroupData"/>. </summary>
        public EventGridNamespaceClientGroupData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventGridNamespaceClientGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description for the Client Group resource. </param>
        /// <param name="query">
        /// The grouping query for the clients.
        /// Example : attributes.keyName IN ['a', 'b', 'c'].
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the ClientGroup resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EventGridNamespaceClientGroupData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, string query, ClientGroupProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            Query = query;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Description for the Client Group resource. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary>
        /// The grouping query for the clients.
        /// Example : attributes.keyName IN ['a', 'b', 'c'].
        /// </summary>
        [WirePath("properties.query")]
        public string Query { get; set; }
        /// <summary> Provisioning state of the ClientGroup resource. </summary>
        [WirePath("properties.provisioningState")]
        public ClientGroupProvisioningState? ProvisioningState { get; }
    }
}
