// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.EventGrid.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmEventGridModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="EventGrid.CaCertificateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description for the CA Certificate resource. </param>
        /// <param name="encodedCertificate"> Base64 encoded PEM (Privacy Enhanced Mail) format certificate data. </param>
        /// <param name="issueTimeInUtc"> Certificate issue time in UTC. This is a read-only field. </param>
        /// <param name="expiryTimeInUtc"> Certificate expiry time in UTC. This is a read-only field. </param>
        /// <param name="provisioningState"> Provisioning state of the CA Certificate resource. </param>
        /// <returns> A new <see cref="EventGrid.CaCertificateData"/> instance for mocking. </returns>
        public static CaCertificateData CaCertificateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, string encodedCertificate = null, DateTimeOffset? issueTimeInUtc = null, DateTimeOffset? expiryTimeInUtc = null, CaCertificateProvisioningState? provisioningState = null)
        {
            return new CaCertificateData(
                id,
                name,
                resourceType,
                systemData,
                description,
                encodedCertificate,
                issueTimeInUtc,
                expiryTimeInUtc,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.PartnerNamespaceChannelData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="channelType"> The type of the event channel which represents the direction flow of events. </param>
        /// <param name="partnerTopicInfo"> This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource corresponding to the channel. </param>
        /// <param name="partnerDestinationInfo">
        /// This property should be populated when channelType is PartnerDestination and represents information about the partner destination resource corresponding to the channel.
        /// Please note <see cref="PartnerDestinationInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="WebhookPartnerDestinationInfo"/>.
        /// </param>
        /// <param name="messageForActivation"> Context or helpful message that can be used during the approval process by the subscriber. </param>
        /// <param name="provisioningState"> Provisioning state of the channel. </param>
        /// <param name="readinessState"> The readiness state of the corresponding partner topic. </param>
        /// <param name="expireOnIfNotActivated">
        /// Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated,
        /// the channel and corresponding partner topic are deleted.
        /// </param>
        /// <returns> A new <see cref="EventGrid.PartnerNamespaceChannelData"/> instance for mocking. </returns>
        public static PartnerNamespaceChannelData PartnerNamespaceChannelData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, PartnerNamespaceChannelType? channelType = null, PartnerTopicInfo partnerTopicInfo = null, PartnerDestinationInfo partnerDestinationInfo = null, string messageForActivation = null, PartnerNamespaceChannelProvisioningState? provisioningState = null, PartnerTopicReadinessState? readinessState = null, DateTimeOffset? expireOnIfNotActivated = null)
        {
            return new PartnerNamespaceChannelData(
                id,
                name,
                resourceType,
                systemData,
                channelType,
                partnerTopicInfo,
                partnerDestinationInfo,
                messageForActivation,
                provisioningState,
                readinessState,
                expireOnIfNotActivated,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EventSubscriptionFullUri"/>. </summary>
        /// <param name="endpoint"> The URL that represents the endpoint of the destination of an event subscription. </param>
        /// <returns> A new <see cref="Models.EventSubscriptionFullUri"/> instance for mocking. </returns>
        public static EventSubscriptionFullUri EventSubscriptionFullUri(Uri endpoint = null)
        {
            return new EventSubscriptionFullUri(endpoint, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridNamespaceClientGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description for the Client Group resource. </param>
        /// <param name="query">
        /// The grouping query for the clients.
        /// Example : attributes.keyName IN ['a', 'b', 'c'].
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the ClientGroup resource. </param>
        /// <returns> A new <see cref="EventGrid.EventGridNamespaceClientGroupData"/> instance for mocking. </returns>
        public static EventGridNamespaceClientGroupData EventGridNamespaceClientGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, string query = null, ClientGroupProvisioningState? provisioningState = null)
        {
            return new EventGridNamespaceClientGroupData(
                id,
                name,
                resourceType,
                systemData,
                description,
                query,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridNamespaceClientData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description for the Client resource. </param>
        /// <param name="authenticationName"> The name presented by the client for authentication. The default value is the name of the resource. </param>
        /// <param name="clientCertificateAuthentication"> The client certificate authentication information. </param>
        /// <param name="state"> Indicates if the client is enabled or not. Default value is Enabled. </param>
        /// <param name="attributes">
        /// Attributes for the client. Supported values are int, bool, string, string[].
        /// Example:
        /// "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the Client resource. </param>
        /// <returns> A new <see cref="EventGrid.EventGridNamespaceClientData"/> instance for mocking. </returns>
        public static EventGridNamespaceClientData EventGridNamespaceClientData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, string authenticationName = null, ClientCertificateAuthentication clientCertificateAuthentication = null, EventGridNamespaceClientState? state = null, IDictionary<string, BinaryData> attributes = null, EventGridNamespaceClientProvisioningState? provisioningState = null)
        {
            attributes ??= new Dictionary<string, BinaryData>();

            return new EventGridNamespaceClientData(
                id,
                name,
                resourceType,
                systemData,
                description,
                authenticationName,
                clientCertificateAuthentication,
                state,
                attributes,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="skuName"> The Sku pricing tier for the Event Grid Domain resource. </param>
        /// <param name="identity"> Identity information for the Event Grid Domain resource. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="provisioningState"> Provisioning state of the Event Grid Domain Resource. </param>
        /// <param name="minimumTlsVersionAllowed"> Minimum TLS version of the publisher allowed to publish to this domain. </param>
        /// <param name="endpoint"> Endpoint for the Event Grid Domain Resource which is used for publishing the events. </param>
        /// <param name="inputSchema"> This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource. </param>
        /// <param name="eventTypeInfo">
        /// Event Type Information for the domain. This information is provided by the publisher and can be used by the
        /// subscriber to view different types of events that are published.
        /// </param>
        /// <param name="inputSchemaMapping">
        /// Information about the InputSchemaMapping which specified the info about mapping event payload.
        /// Please note <see cref="EventGridInputSchemaMapping"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="EventGridJsonInputSchemaMapping"/>.
        /// </param>
        /// <param name="metricResourceId"> Metric resource id for the Event Grid Domain Resource. </param>
        /// <param name="publicNetworkAccess">
        /// This determines if traffic is allowed over public network. By default it is enabled.
        /// You can further restrict to specific IPs by configuring &lt;seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" /&gt;
        /// </param>
        /// <param name="inboundIPRules"> This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled. </param>
        /// <param name="isLocalAuthDisabled"> This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the domain. </param>
        /// <param name="autoCreateTopicWithFirstSubscription">
        /// This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
        /// In this context, creation of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
        /// When this property is null or set to true, Event Grid is responsible of automatically creating the domain topic when the first event subscription is
        /// created at the scope of the domain topic. If this property is set to false, then creating the first event subscription will require creating a domain topic
        /// by the user. The self-management mode can be used if the user wants full control of when the domain topic is created, while auto-managed mode provides the
        /// flexibility to perform less operations and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the
        /// domain topic on demand if needed.
        /// </param>
        /// <param name="autoDeleteTopicWithLastSubscription">
        /// This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
        /// In this context, deletion of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
        /// When this property is set to true, Event Grid is responsible of automatically deleting the domain topic when the last event subscription at the scope
        /// of the domain topic is deleted. If this property is set to false, then the user needs to manually delete the domain topic when it is no longer needed
        /// (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode can be used if the user wants full
        /// control of when the domain topic needs to be deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer
        /// resources by the user.
        /// </param>
        /// <param name="dataResidencyBoundary"> Data Residency Boundary of the resource. </param>
        /// <returns> A new <see cref="EventGrid.EventGridDomainData"/> instance for mocking. </returns>
        public static EventGridDomainData EventGridDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, EventGridSku? skuName = null, ManagedServiceIdentity identity = null, IEnumerable<EventGridPrivateEndpointConnectionData> privateEndpointConnections = null, EventGridDomainProvisioningState? provisioningState = null, TlsVersion? minimumTlsVersionAllowed = null, Uri endpoint = null, EventGridInputSchema? inputSchema = null, PartnerTopicEventTypeInfo eventTypeInfo = null, EventGridInputSchemaMapping inputSchemaMapping = null, string metricResourceId = null, EventGridPublicNetworkAccess? publicNetworkAccess = null, IEnumerable<EventGridInboundIPRule> inboundIPRules = null, bool? isLocalAuthDisabled = null, bool? autoCreateTopicWithFirstSubscription = null, bool? autoDeleteTopicWithLastSubscription = null, DataResidencyBoundary? dataResidencyBoundary = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<EventGridPrivateEndpointConnectionData>();
            inboundIPRules ??= new List<EventGridInboundIPRule>();

            return new EventGridDomainData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                skuName != null ? new ResourceSku(skuName, serializedAdditionalRawData: null) : null,
                identity,
                privateEndpointConnections?.ToList(),
                provisioningState,
                minimumTlsVersionAllowed,
                endpoint,
                inputSchema,
                eventTypeInfo,
                inputSchemaMapping,
                metricResourceId,
                publicNetworkAccess,
                inboundIPRules?.ToList(),
                isLocalAuthDisabled,
                autoCreateTopicWithFirstSubscription,
                autoDeleteTopicWithLastSubscription,
                dataResidencyBoundary,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The Private Endpoint resource for this Connection. </param>
        /// <param name="groupIds"> GroupIds from the private link service resource. </param>
        /// <param name="connectionState"> Details about the state of the connection. </param>
        /// <param name="provisioningState"> Provisioning state of the Private Endpoint Connection. </param>
        /// <returns> A new <see cref="EventGrid.EventGridPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static EventGridPrivateEndpointConnectionData EventGridPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, IEnumerable<string> groupIds = null, EventGridPrivateEndpointConnectionState connectionState = null, EventGridResourceProvisioningState? provisioningState = null)
        {
            groupIds ??= new List<string>();

            return new EventGridPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.WritableSubResource(privateEndpointId) : null,
                groupIds?.ToList(),
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EventGridDomainSharedAccessKeys"/>. </summary>
        /// <param name="key1"> Shared access key1 for the domain. </param>
        /// <param name="key2"> Shared access key2 for the domain. </param>
        /// <returns> A new <see cref="Models.EventGridDomainSharedAccessKeys"/> instance for mocking. </returns>
        public static EventGridDomainSharedAccessKeys EventGridDomainSharedAccessKeys(string key1 = null, string key2 = null)
        {
            return new EventGridDomainSharedAccessKeys(key1, key2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.DomainTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning state of the domain topic. </param>
        /// <returns> A new <see cref="EventGrid.DomainTopicData"/> instance for mocking. </returns>
        public static DomainTopicData DomainTopicData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DomainTopicProvisioningState? provisioningState = null)
        {
            return new DomainTopicData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.NamespaceTopicEventSubscriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning state of the event subscription. </param>
        /// <param name="deliveryConfiguration"> Information about the delivery configuration of the event subscription. </param>
        /// <param name="eventDeliverySchema"> The event delivery schema for the event subscription. </param>
        /// <param name="filtersConfiguration"> Information about the filter for the event subscription. </param>
        /// <param name="expireOn"> Expiration time of the event subscription. </param>
        /// <returns> A new <see cref="EventGrid.NamespaceTopicEventSubscriptionData"/> instance for mocking. </returns>
        public static NamespaceTopicEventSubscriptionData NamespaceTopicEventSubscriptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SubscriptionProvisioningState? provisioningState = null, DeliveryConfiguration deliveryConfiguration = null, DeliverySchema? eventDeliverySchema = null, FiltersConfiguration filtersConfiguration = null, DateTimeOffset? expireOn = null)
        {
            return new NamespaceTopicEventSubscriptionData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                deliveryConfiguration,
                eventDeliverySchema,
                filtersConfiguration,
                expireOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridSubscriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="topic"> Name of the topic of the event subscription. </param>
        /// <param name="provisioningState"> Provisioning state of the event subscription. </param>
        /// <param name="destination">
        /// Information about the destination where events have to be delivered for the event subscription.
        /// Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
        /// Please note <see cref="EventSubscriptionDestination"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureFunctionEventSubscriptionDestination"/>, <see cref="EventHubEventSubscriptionDestination"/>, <see cref="HybridConnectionEventSubscriptionDestination"/>, <see cref="MonitorAlertEventSubscriptionDestination"/>, <see cref="NamespaceTopicEventSubscriptionDestination"/>, <see cref="PartnerEventSubscriptionDestination"/>, <see cref="ServiceBusQueueEventSubscriptionDestination"/>, <see cref="ServiceBusTopicEventSubscriptionDestination"/>, <see cref="StorageQueueEventSubscriptionDestination"/> and <see cref="Models.WebHookEventSubscriptionDestination"/>.
        /// </param>
        /// <param name="deliveryWithResourceIdentity">
        /// Information about the destination where events have to be delivered for the event subscription.
        /// Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
        /// </param>
        /// <param name="filter"> Information about the filter for the event subscription. </param>
        /// <param name="labels"> List of user defined labels. </param>
        /// <param name="expireOn"> Expiration time of the event subscription. </param>
        /// <param name="eventDeliverySchema"> The event delivery schema for the event subscription. </param>
        /// <param name="retryPolicy"> The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events. </param>
        /// <param name="deadLetterDestination">
        /// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
        /// Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
        /// Please note <see cref="DeadLetterDestination"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="StorageBlobDeadLetterDestination"/>.
        /// </param>
        /// <param name="deadLetterWithResourceIdentity">
        /// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
        /// Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
        /// </param>
        /// <returns> A new <see cref="EventGrid.EventGridSubscriptionData"/> instance for mocking. </returns>
        public static EventGridSubscriptionData EventGridSubscriptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string topic = null, EventSubscriptionProvisioningState? provisioningState = null, EventSubscriptionDestination destination = null, DeliveryWithResourceIdentity deliveryWithResourceIdentity = null, EventSubscriptionFilter filter = null, IEnumerable<string> labels = null, DateTimeOffset? expireOn = null, EventDeliverySchema? eventDeliverySchema = null, EventSubscriptionRetryPolicy retryPolicy = null, DeadLetterDestination deadLetterDestination = null, DeadLetterWithResourceIdentity deadLetterWithResourceIdentity = null)
        {
            labels ??= new List<string>();

            return new EventGridSubscriptionData(
                id,
                name,
                resourceType,
                systemData,
                topic,
                provisioningState,
                destination,
                deliveryWithResourceIdentity,
                filter,
                labels?.ToList(),
                expireOn,
                eventDeliverySchema,
                retryPolicy,
                deadLetterDestination,
                deadLetterWithResourceIdentity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridNamespaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> Represents available Sku pricing tiers. </param>
        /// <param name="identity"> Identity information for the Namespace resource. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="provisioningState"> Provisioning state of the namespace resource. </param>
        /// <param name="topicsConfiguration"> Topics configuration information for the namespace resource. </param>
        /// <param name="topicSpacesConfiguration"> Topic spaces configuration information for the namespace resource. </param>
        /// <param name="isZoneRedundant">
        /// This is an optional property and it allows the user to specify if the namespace resource supports zone-redundancy capability or not. If this
        /// property is not specified explicitly by the user, its default value depends on the following conditions:
        ///     a. For Availability Zones enabled regions - The default property value would be true.
        ///     b. For non-Availability Zones enabled regions - The default property value would be false.
        /// Once specified, this property cannot be updated.
        /// </param>
        /// <param name="publicNetworkAccess">
        /// This determines if traffic is allowed over public network. By default it is enabled.
        /// You can further restrict to specific IPs by configuring &lt;seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" /&gt;
        /// </param>
        /// <param name="inboundIPRules"> This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled. </param>
        /// <param name="minimumTlsVersionAllowed"> Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported. </param>
        /// <returns> A new <see cref="EventGrid.EventGridNamespaceData"/> instance for mocking. </returns>
        public static EventGridNamespaceData EventGridNamespaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, NamespaceSku sku = null, ManagedServiceIdentity identity = null, IEnumerable<EventGridPrivateEndpointConnectionData> privateEndpointConnections = null, NamespaceProvisioningState? provisioningState = null, TopicsConfiguration topicsConfiguration = null, TopicSpacesConfiguration topicSpacesConfiguration = null, bool? isZoneRedundant = null, EventGridPublicNetworkAccess? publicNetworkAccess = null, IEnumerable<EventGridInboundIPRule> inboundIPRules = null, TlsVersion? minimumTlsVersionAllowed = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<EventGridPrivateEndpointConnectionData>();
            inboundIPRules ??= new List<EventGridInboundIPRule>();

            return new EventGridNamespaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                identity,
                privateEndpointConnections?.ToList(),
                provisioningState,
                topicsConfiguration,
                topicSpacesConfiguration,
                isZoneRedundant,
                publicNetworkAccess,
                inboundIPRules?.ToList(),
                minimumTlsVersionAllowed,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TopicsConfiguration"/>. </summary>
        /// <param name="hostname"> The hostname for the topics configuration. This is a read-only property. </param>
        /// <param name="customDomains"> List of custom domain configurations for the namespace. </param>
        /// <returns> A new <see cref="Models.TopicsConfiguration"/> instance for mocking. </returns>
        public static TopicsConfiguration TopicsConfiguration(string hostname = null, IEnumerable<CustomDomainConfiguration> customDomains = null)
        {
            customDomains ??= new List<CustomDomainConfiguration>();

            return new TopicsConfiguration(hostname, customDomains?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TopicSpacesConfiguration"/>. </summary>
        /// <param name="state"> Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled. </param>
        /// <param name="routeTopicResourceId">
        /// Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
        /// This property should be in the following format '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
        /// This topic should reside in the same region where namespace is located.
        /// </param>
        /// <param name="hostname"> The endpoint for the topic spaces configuration. This is a read-only property. </param>
        /// <param name="routingEnrichments"> Routing enrichments for topic spaces configuration. </param>
        /// <param name="clientAuthentication"> Client authentication settings for topic spaces configuration. </param>
        /// <param name="maximumSessionExpiryInHours">
        /// The maximum session expiry in hours. The property default value is 1 hour.
        /// Min allowed value is 1 hour and max allowed value is 8 hours.
        /// </param>
        /// <param name="maximumClientSessionsPerAuthenticationName">
        /// The maximum number of sessions per authentication name. The property default value is 1.
        /// Min allowed value is 1 and max allowed value is 100.
        /// </param>
        /// <param name="routingIdentityInfo"> Routing identity info for topic spaces configuration. </param>
        /// <param name="customDomains"> List of custom domain configurations for the namespace. </param>
        /// <returns> A new <see cref="Models.TopicSpacesConfiguration"/> instance for mocking. </returns>
        public static TopicSpacesConfiguration TopicSpacesConfiguration(TopicSpacesConfigurationState? state = null, string routeTopicResourceId = null, string hostname = null, RoutingEnrichments routingEnrichments = null, ClientAuthenticationSettings clientAuthentication = null, int? maximumSessionExpiryInHours = null, int? maximumClientSessionsPerAuthenticationName = null, RoutingIdentityInfo routingIdentityInfo = null, IEnumerable<CustomDomainConfiguration> customDomains = null)
        {
            customDomains ??= new List<CustomDomainConfiguration>();

            return new TopicSpacesConfiguration(
                state,
                routeTopicResourceId,
                hostname,
                routingEnrichments,
                clientAuthentication,
                maximumSessionExpiryInHours,
                maximumClientSessionsPerAuthenticationName,
                routingIdentityInfo,
                customDomains?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NamespaceSharedAccessKeys"/>. </summary>
        /// <param name="key1"> Shared access key1 for the namespace. </param>
        /// <param name="key2"> Shared access key2 for the namespace. </param>
        /// <returns> A new <see cref="Models.NamespaceSharedAccessKeys"/> instance for mocking. </returns>
        public static NamespaceSharedAccessKeys NamespaceSharedAccessKeys(string key1 = null, string key2 = null)
        {
            return new NamespaceSharedAccessKeys(key1, key2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.NamespaceTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning state of the namespace topic. </param>
        /// <param name="publisherType"> Publisher type of the namespace topic. </param>
        /// <param name="inputSchema"> This determines the format that is expected for incoming events published to the topic. </param>
        /// <param name="eventRetentionInDays">
        /// Event retention for the namespace topic expressed in days. The property default value is 1 day.
        /// Min event retention duration value is 1 day and max event retention duration value is 1 day.
        /// </param>
        /// <returns> A new <see cref="EventGrid.NamespaceTopicData"/> instance for mocking. </returns>
        public static NamespaceTopicData NamespaceTopicData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NamespaceTopicProvisioningState? provisioningState = null, PublisherType? publisherType = null, EventInputSchema? inputSchema = null, int? eventRetentionInDays = null)
        {
            return new NamespaceTopicData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                publisherType,
                inputSchema,
                eventRetentionInDays,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TopicSharedAccessKeys"/>. </summary>
        /// <param name="key1"> Shared access key1 for the topic. </param>
        /// <param name="key2"> Shared access key2 for the topic. </param>
        /// <returns> A new <see cref="Models.TopicSharedAccessKeys"/> instance for mocking. </returns>
        public static TopicSharedAccessKeys TopicSharedAccessKeys(string key1 = null, string key2 = null)
        {
            return new TopicSharedAccessKeys(key1, key2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.PartnerConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="partnerAuthorization"> The details of authorized partners. </param>
        /// <param name="provisioningState"> Provisioning state of the partner configuration. </param>
        /// <returns> A new <see cref="EventGrid.PartnerConfigurationData"/> instance for mocking. </returns>
        public static PartnerConfigurationData PartnerConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, PartnerAuthorization partnerAuthorization = null, PartnerConfigurationProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new PartnerConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                partnerAuthorization,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.PartnerDestinationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="partnerRegistrationImmutableId"> The immutable Id of the corresponding partner registration. </param>
        /// <param name="endpointServiceContext"> Endpoint context associated with this partner destination. </param>
        /// <param name="expirationTimeIfNotActivatedUtc">
        /// Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
        /// the partner destination and corresponding channel are deleted.
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the partner destination. </param>
        /// <param name="activationState"> Activation state of the partner destination. </param>
        /// <param name="endpointBaseUri"> Endpoint Base URL of the partner destination. </param>
        /// <param name="messageForActivation"> Context or helpful message that can be used during the approval process. </param>
        /// <returns> A new <see cref="EventGrid.PartnerDestinationData"/> instance for mocking. </returns>
        public static PartnerDestinationData PartnerDestinationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, Guid? partnerRegistrationImmutableId = null, string endpointServiceContext = null, DateTimeOffset? expirationTimeIfNotActivatedUtc = null, PartnerDestinationProvisioningState? provisioningState = null, PartnerDestinationActivationState? activationState = null, Uri endpointBaseUri = null, string messageForActivation = null)
        {
            tags ??= new Dictionary<string, string>();

            return new PartnerDestinationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                partnerRegistrationImmutableId,
                endpointServiceContext,
                expirationTimeIfNotActivatedUtc,
                provisioningState,
                activationState,
                endpointBaseUri,
                messageForActivation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.PartnerNamespaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="provisioningState"> Provisioning state of the partner namespace. </param>
        /// <param name="partnerRegistrationFullyQualifiedId">
        /// The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes the following format:
        /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
        /// </param>
        /// <param name="minimumTlsVersionAllowed"> Minimum TLS version of the publisher allowed to publish to this partner namespace. </param>
        /// <param name="endpoint"> Endpoint for the partner namespace. </param>
        /// <param name="publicNetworkAccess">
        /// This determines if traffic is allowed over public network. By default it is enabled.
        /// You can further restrict to specific IPs by configuring &lt;seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules" /&gt;
        /// </param>
        /// <param name="inboundIPRules"> This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled. </param>
        /// <param name="isLocalAuthDisabled"> This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the partner namespace. </param>
        /// <param name="partnerTopicRoutingMode">
        /// This determines if events published to this partner namespace should use the source attribute in the event payload
        /// or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
        /// </param>
        /// <returns> A new <see cref="EventGrid.PartnerNamespaceData"/> instance for mocking. </returns>
        public static PartnerNamespaceData PartnerNamespaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<EventGridPrivateEndpointConnectionData> privateEndpointConnections = null, PartnerNamespaceProvisioningState? provisioningState = null, ResourceIdentifier partnerRegistrationFullyQualifiedId = null, TlsVersion? minimumTlsVersionAllowed = null, Uri endpoint = null, EventGridPublicNetworkAccess? publicNetworkAccess = null, IEnumerable<EventGridInboundIPRule> inboundIPRules = null, bool? isLocalAuthDisabled = null, PartnerTopicRoutingMode? partnerTopicRoutingMode = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<EventGridPrivateEndpointConnectionData>();
            inboundIPRules ??= new List<EventGridInboundIPRule>();

            return new PartnerNamespaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                privateEndpointConnections?.ToList(),
                provisioningState,
                partnerRegistrationFullyQualifiedId,
                minimumTlsVersionAllowed,
                endpoint,
                publicNetworkAccess,
                inboundIPRules?.ToList(),
                isLocalAuthDisabled,
                partnerTopicRoutingMode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PartnerNamespaceSharedAccessKeys"/>. </summary>
        /// <param name="key1"> Shared access key1 for the partner namespace. </param>
        /// <param name="key2"> Shared access key2 for the partner namespace. </param>
        /// <returns> A new <see cref="Models.PartnerNamespaceSharedAccessKeys"/> instance for mocking. </returns>
        public static PartnerNamespaceSharedAccessKeys PartnerNamespaceSharedAccessKeys(string key1 = null, string key2 = null)
        {
            return new PartnerNamespaceSharedAccessKeys(key1, key2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.PartnerRegistrationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state of the partner registration. </param>
        /// <param name="partnerRegistrationImmutableId">
        /// The immutableId of the corresponding partner registration.
        /// Note: This property is marked for deprecation and is not supported in any future GA API version
        /// </param>
        /// <returns> A new <see cref="EventGrid.PartnerRegistrationData"/> instance for mocking. </returns>
        public static PartnerRegistrationData PartnerRegistrationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, PartnerRegistrationProvisioningState? provisioningState = null, Guid? partnerRegistrationImmutableId = null)
        {
            tags ??= new Dictionary<string, string>();

            return new PartnerRegistrationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                partnerRegistrationImmutableId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.PartnerTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity information for the Partner Topic resource. </param>
        /// <param name="partnerRegistrationImmutableId"> The immutableId of the corresponding partner registration. </param>
        /// <param name="source"> Source associated with this partner topic. This represents a unique partner resource. </param>
        /// <param name="eventTypeInfo"> Event Type information from the corresponding event channel. </param>
        /// <param name="expireOnIfNotActivated">
        /// Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
        /// the partner topic and corresponding event channel are deleted.
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the partner topic. </param>
        /// <param name="activationState"> Activation state of the partner topic. </param>
        /// <param name="partnerTopicFriendlyDescription">
        /// Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
        /// This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
        /// </param>
        /// <param name="messageForActivation"> Context or helpful message that can be used during the approval process by the subscriber. </param>
        /// <returns> A new <see cref="EventGrid.PartnerTopicData"/> instance for mocking. </returns>
        public static PartnerTopicData PartnerTopicData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, Guid? partnerRegistrationImmutableId = null, string source = null, PartnerTopicEventTypeInfo eventTypeInfo = null, DateTimeOffset? expireOnIfNotActivated = null, PartnerTopicProvisioningState? provisioningState = null, PartnerTopicActivationState? activationState = null, string partnerTopicFriendlyDescription = null, string messageForActivation = null)
        {
            tags ??= new Dictionary<string, string>();

            return new PartnerTopicData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                partnerRegistrationImmutableId,
                source,
                eventTypeInfo,
                expireOnIfNotActivated,
                provisioningState,
                activationState,
                partnerTopicFriendlyDescription,
                messageForActivation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.NetworkSecurityPerimeterConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning state to reflect configuration state and indicate status of nsp profile configuration retrieval. </param>
        /// <param name="provisioningIssues"> Provisioning issues to reflect status when attempting to retrieve nsp profile configuration. </param>
        /// <param name="networkSecurityPerimeter"> Perimeter info for nsp association. </param>
        /// <param name="resourceAssociation"> Nsp association name and access mode of association. </param>
        /// <param name="profile"> Nsp profile configuration, access rules and diagnostic settings. </param>
        /// <returns> A new <see cref="EventGrid.NetworkSecurityPerimeterConfigurationData"/> instance for mocking. </returns>
        public static NetworkSecurityPerimeterConfigurationData NetworkSecurityPerimeterConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NetworkSecurityPerimeterConfigProvisioningState? provisioningState = null, IEnumerable<NetworkSecurityPerimeterConfigurationIssues> provisioningIssues = null, NetworkSecurityPerimeterInfo networkSecurityPerimeter = null, ResourceAssociation resourceAssociation = null, NetworkSecurityPerimeterConfigurationProfile profile = null)
        {
            provisioningIssues ??= new List<NetworkSecurityPerimeterConfigurationIssues>();

            return new NetworkSecurityPerimeterConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                provisioningIssues?.ToList(),
                networkSecurityPerimeter,
                resourceAssociation,
                profile,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridNamespacePermissionBindingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description for the Permission Binding resource. </param>
        /// <param name="topicSpaceName">
        /// The name of the Topic Space resource that the permission is bound to.
        /// The Topic space needs to be a resource under the same namespace the permission binding is a part of.
        /// </param>
        /// <param name="permission"> The allowed permission. </param>
        /// <param name="clientGroupName">
        /// The name of the client group resource that the permission is bound to.
        /// The client group needs to be a resource under the same namespace the permission binding is a part of.
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the PermissionBinding resource. </param>
        /// <returns> A new <see cref="EventGrid.EventGridNamespacePermissionBindingData"/> instance for mocking. </returns>
        public static EventGridNamespacePermissionBindingData EventGridNamespacePermissionBindingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, string topicSpaceName = null, PermissionType? permission = null, string clientGroupName = null, PermissionBindingProvisioningState? provisioningState = null)
        {
            return new EventGridNamespacePermissionBindingData(
                id,
                name,
                resourceType,
                systemData,
                description,
                topicSpaceName,
                permission,
                clientGroupName,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"></param>
        /// <param name="displayName"></param>
        /// <param name="requiredMembers"></param>
        /// <param name="requiredZoneNames"></param>
        /// <returns> A new <see cref="EventGrid.EventGridPrivateLinkResourceData"/> instance for mocking. </returns>
        public static EventGridPrivateLinkResourceData EventGridPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, string displayName = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new EventGridPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                displayName,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.SystemTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity information for the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the system topic. </param>
        /// <param name="source"> Source for the system topic. </param>
        /// <param name="topicType"> TopicType for the system topic. </param>
        /// <param name="metricResourceId"> Metric resource id for the system topic. </param>
        /// <returns> A new <see cref="EventGrid.SystemTopicData"/> instance for mocking. </returns>
        public static SystemTopicData SystemTopicData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, EventGridResourceProvisioningState? provisioningState = null, ResourceIdentifier source = null, string topicType = null, Guid? metricResourceId = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SystemTopicData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                provisioningState,
                source,
                topicType,
                metricResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.EventGridTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="skuName"> The Sku pricing tier for the topic. </param>
        /// <param name="identity"> Identity information for the resource. </param>
        /// <param name="kind"> Kind of the resource. </param>
        /// <param name="extendedLocation"> Extended location of the resource. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="provisioningState"> Provisioning state of the topic. </param>
        /// <param name="endpoint"> Endpoint for the topic. </param>
        /// <param name="eventTypeInfo">
        /// Event Type Information for the user topic. This information is provided by the publisher and can be used by the
        /// subscriber to view different types of events that are published.
        /// </param>
        /// <param name="minimumTlsVersionAllowed"> Minimum TLS version of the publisher allowed to publish to this topic. </param>
        /// <param name="inputSchema"> This determines the format that Event Grid should expect for incoming events published to the topic. </param>
        /// <param name="inputSchemaMapping">
        /// This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
        /// Please note <see cref="EventGridInputSchemaMapping"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="EventGridJsonInputSchemaMapping"/>.
        /// </param>
        /// <param name="metricResourceId"> Metric resource id for the topic. </param>
        /// <param name="publicNetworkAccess">
        /// This determines if traffic is allowed over public network. By default it is enabled.
        /// You can further restrict to specific IPs by configuring &lt;seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" /&gt;
        /// </param>
        /// <param name="inboundIPRules"> This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled. </param>
        /// <param name="isLocalAuthDisabled"> This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the topic. </param>
        /// <param name="dataResidencyBoundary"> Data Residency Boundary of the resource. </param>
        /// <returns> A new <see cref="EventGrid.EventGridTopicData"/> instance for mocking. </returns>
        public static EventGridTopicData EventGridTopicData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, EventGridSku? skuName = null, ManagedServiceIdentity identity = null, ResourceKind? kind = null, ExtendedLocation extendedLocation = null, IEnumerable<EventGridPrivateEndpointConnectionData> privateEndpointConnections = null, EventGridTopicProvisioningState? provisioningState = null, Uri endpoint = null, PartnerTopicEventTypeInfo eventTypeInfo = null, TlsVersion? minimumTlsVersionAllowed = null, EventGridInputSchema? inputSchema = null, EventGridInputSchemaMapping inputSchemaMapping = null, string metricResourceId = null, EventGridPublicNetworkAccess? publicNetworkAccess = null, IEnumerable<EventGridInboundIPRule> inboundIPRules = null, bool? isLocalAuthDisabled = null, DataResidencyBoundary? dataResidencyBoundary = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<EventGridPrivateEndpointConnectionData>();
            inboundIPRules ??= new List<EventGridInboundIPRule>();

            return new EventGridTopicData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                skuName != null ? new ResourceSku(skuName, serializedAdditionalRawData: null) : null,
                identity,
                kind,
                extendedLocation,
                privateEndpointConnections?.ToList(),
                provisioningState,
                endpoint,
                eventTypeInfo,
                minimumTlsVersionAllowed,
                inputSchema,
                inputSchemaMapping,
                metricResourceId,
                publicNetworkAccess,
                inboundIPRules?.ToList(),
                isLocalAuthDisabled,
                dataResidencyBoundary,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EventTypeUnderTopic"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> Display name of the event type. </param>
        /// <param name="description"> Description of the event type. </param>
        /// <param name="schemaUri"> Url of the schema for this event type. </param>
        /// <param name="isInDefaultSet"> IsInDefaultSet flag of the event type. </param>
        /// <returns> A new <see cref="Models.EventTypeUnderTopic"/> instance for mocking. </returns>
        public static EventTypeUnderTopic EventTypeUnderTopic(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string displayName = null, string description = null, Uri schemaUri = null, bool? isInDefaultSet = null)
        {
            return new EventTypeUnderTopic(
                id,
                name,
                resourceType,
                systemData,
                displayName,
                description,
                schemaUri,
                isInDefaultSet,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.ExtensionTopicData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description of the extension topic. </param>
        /// <param name="systemTopic"> System topic resource id which is mapped to the source. </param>
        /// <returns> A new <see cref="EventGrid.ExtensionTopicData"/> instance for mocking. </returns>
        public static ExtensionTopicData ExtensionTopicData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, string systemTopic = null)
        {
            return new ExtensionTopicData(
                id,
                name,
                resourceType,
                systemData,
                description,
                systemTopic,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.TopicSpaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description for the Topic Space resource. </param>
        /// <param name="topicTemplates">
        /// The topic filters in the topic space.
        /// Example: "topicTemplates": [
        ///               "devices/foo/bar",
        ///               "devices/topic1/+",
        ///               "devices/${principal.name}/${principal.attributes.keyName}" ].
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the TopicSpace resource. </param>
        /// <returns> A new <see cref="EventGrid.TopicSpaceData"/> instance for mocking. </returns>
        public static TopicSpaceData TopicSpaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<string> topicTemplates = null, TopicSpaceProvisioningState? provisioningState = null)
        {
            topicTemplates ??= new List<string>();

            return new TopicSpaceData(
                id,
                name,
                resourceType,
                systemData,
                description,
                topicTemplates?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.TopicTypeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provider"> Namespace of the provider of the topic type. </param>
        /// <param name="displayName"> Display Name for the topic type. </param>
        /// <param name="description"> Description of the topic type. </param>
        /// <param name="resourceRegionType"> Region type of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the topic type. </param>
        /// <param name="supportedLocations"> List of locations supported by this topic type. </param>
        /// <param name="sourceResourceFormat"> Source resource format. </param>
        /// <param name="supportedScopesForSource"> Supported source scopes. </param>
        /// <param name="areRegionalAndGlobalSourcesSupported"> Flag to indicate that a topic type can support both regional or global system topics. </param>
        /// <param name="additionalEnforcedPermissions"> Permissions which are enforced for creating and updating system topics of this this topic type. </param>
        /// <returns> A new <see cref="EventGrid.TopicTypeData"/> instance for mocking. </returns>
        public static TopicTypeData TopicTypeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string provider = null, string displayName = null, string description = null, EventGridResourceRegionType? resourceRegionType = null, TopicTypeProvisioningState? provisioningState = null, IEnumerable<string> supportedLocations = null, string sourceResourceFormat = null, IEnumerable<TopicTypeSourceScope> supportedScopesForSource = null, bool? areRegionalAndGlobalSourcesSupported = null, IEnumerable<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions = null)
        {
            supportedLocations ??= new List<string>();
            supportedScopesForSource ??= new List<TopicTypeSourceScope>();
            additionalEnforcedPermissions ??= new List<TopicTypeAdditionalEnforcedPermission>();

            return new TopicTypeData(
                id,
                name,
                resourceType,
                systemData,
                provider,
                displayName,
                description,
                resourceRegionType,
                provisioningState,
                supportedLocations?.ToList(),
                sourceResourceFormat,
                supportedScopesForSource?.ToList(),
                areRegionalAndGlobalSourcesSupported,
                additionalEnforcedPermissions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EventGrid.VerifiedPartnerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="partnerRegistrationImmutableId"> ImmutableId of the corresponding partner registration. </param>
        /// <param name="organizationName"> Official name of the Partner. </param>
        /// <param name="partnerDisplayName"> Display name of the verified partner. </param>
        /// <param name="partnerTopicDetails"> Details of the partner topic scenario. </param>
        /// <param name="partnerDestinationDetails"> Details of the partner destination scenario. </param>
        /// <param name="provisioningState"> Provisioning state of the verified partner. </param>
        /// <returns> A new <see cref="EventGrid.VerifiedPartnerData"/> instance for mocking. </returns>
        public static VerifiedPartnerData VerifiedPartnerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? partnerRegistrationImmutableId = null, string organizationName = null, string partnerDisplayName = null, PartnerDetails partnerTopicDetails = null, PartnerDetails partnerDestinationDetails = null, VerifiedPartnerProvisioningState? provisioningState = null)
        {
            return new VerifiedPartnerData(
                id,
                name,
                resourceType,
                systemData,
                partnerRegistrationImmutableId,
                organizationName,
                partnerDisplayName,
                partnerTopicDetails,
                partnerDestinationDetails,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomDomainOwnershipValidationResult"/>. </summary>
        /// <param name="customDomainsForTopicsConfiguration"> List of custom domain configurations for the namespace under topics configuration. </param>
        /// <param name="customDomainsForTopicSpacesConfiguration"> List of custom domain configurations for the namespace under topic spaces configuration. </param>
        /// <returns> A new <see cref="Models.CustomDomainOwnershipValidationResult"/> instance for mocking. </returns>
        public static CustomDomainOwnershipValidationResult CustomDomainOwnershipValidationResult(IEnumerable<CustomDomainConfiguration> customDomainsForTopicsConfiguration = null, IEnumerable<CustomDomainConfiguration> customDomainsForTopicSpacesConfiguration = null)
        {
            customDomainsForTopicsConfiguration ??= new List<CustomDomainConfiguration>();
            customDomainsForTopicSpacesConfiguration ??= new List<CustomDomainConfiguration>();

            return new CustomDomainOwnershipValidationResult(customDomainsForTopicsConfiguration?.ToList(), customDomainsForTopicSpacesConfiguration?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SubscriptionFullUri"/>. </summary>
        /// <param name="endpointUri"> The URL that represents the endpoint of the destination of an event subscription. </param>
        /// <returns> A new <see cref="Models.SubscriptionFullUri"/> instance for mocking. </returns>
        public static SubscriptionFullUri SubscriptionFullUri(Uri endpointUri = null)
        {
            return new SubscriptionFullUri(endpointUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WebHookEventSubscriptionDestination"/>. </summary>
        /// <param name="endpoint"> The URL that represents the endpoint of the destination of an event subscription. </param>
        /// <param name="baseEndpoint"> The base URL that represents the endpoint of the destination of an event subscription. </param>
        /// <param name="maxEventsPerBatch"> Maximum number of events per batch. </param>
        /// <param name="preferredBatchSizeInKilobytes"> Preferred batch size in Kilobytes. </param>
        /// <param name="azureActiveDirectoryTenantId"> The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests. </param>
        /// <param name="uriOrAzureActiveDirectoryApplicationId"> The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests. </param>
        /// <param name="deliveryAttributeMappings">
        /// Delivery attribute details.
        /// Please note <see cref="DeliveryAttributeMapping"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DynamicDeliveryAttributeMapping"/> and <see cref="StaticDeliveryAttributeMapping"/>.
        /// </param>
        /// <param name="minimumTlsVersionAllowed"> Minimum TLS version that should be supported by webhook endpoint. </param>
        /// <returns> A new <see cref="Models.WebHookEventSubscriptionDestination"/> instance for mocking. </returns>
        public static WebHookEventSubscriptionDestination WebHookEventSubscriptionDestination(Uri endpoint = null, Uri baseEndpoint = null, int? maxEventsPerBatch = null, int? preferredBatchSizeInKilobytes = null, Guid? azureActiveDirectoryTenantId = null, string uriOrAzureActiveDirectoryApplicationId = null, IEnumerable<DeliveryAttributeMapping> deliveryAttributeMappings = null, TlsVersion? minimumTlsVersionAllowed = null)
        {
            deliveryAttributeMappings ??= new List<DeliveryAttributeMapping>();

            return new WebHookEventSubscriptionDestination(
                EndpointType.WebHook,
                serializedAdditionalRawData: null,
                endpoint,
                baseEndpoint,
                maxEventsPerBatch,
                preferredBatchSizeInKilobytes,
                azureActiveDirectoryTenantId,
                uriOrAzureActiveDirectoryApplicationId,
                deliveryAttributeMappings?.ToList(),
                minimumTlsVersionAllowed);
        }
    }
}
