// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.EventGrid.Models;

namespace Azure.ResourceManager.EventGrid.Samples
{
    public partial class Sample_EventGridNamespacePermissionBindingResource
    {
        // PermissionBindings_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PermissionBindingsGet()
        {
            // Generated from example definition: specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/PermissionBindings_Get.json
            // this example is just showing the usage of "PermissionBindings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventGridNamespacePermissionBindingResource created on azure
            // for more information of creating EventGridNamespacePermissionBindingResource, please refer to the document of EventGridNamespacePermissionBindingResource
            string subscriptionId = "8f6b6269-84f2-4d09-9e31-1127efcd1e40";
            string resourceGroupName = "examplerg";
            string namespaceName = "exampleNamespaceName1";
            string permissionBindingName = "examplePermissionBindingName1";
            ResourceIdentifier eventGridNamespacePermissionBindingResourceId = EventGridNamespacePermissionBindingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, permissionBindingName);
            EventGridNamespacePermissionBindingResource eventGridNamespacePermissionBinding = client.GetEventGridNamespacePermissionBindingResource(eventGridNamespacePermissionBindingResourceId);

            // invoke the operation
            EventGridNamespacePermissionBindingResource result = await eventGridNamespacePermissionBinding.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventGridNamespacePermissionBindingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PermissionBindings_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PermissionBindingsCreateOrUpdate()
        {
            // Generated from example definition: specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/PermissionBindings_CreateOrUpdate.json
            // this example is just showing the usage of "PermissionBindings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventGridNamespacePermissionBindingResource created on azure
            // for more information of creating EventGridNamespacePermissionBindingResource, please refer to the document of EventGridNamespacePermissionBindingResource
            string subscriptionId = "8f6b6269-84f2-4d09-9e31-1127efcd1e40";
            string resourceGroupName = "examplerg";
            string namespaceName = "exampleNamespaceName1";
            string permissionBindingName = "examplePermissionBindingName1";
            ResourceIdentifier eventGridNamespacePermissionBindingResourceId = EventGridNamespacePermissionBindingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, permissionBindingName);
            EventGridNamespacePermissionBindingResource eventGridNamespacePermissionBinding = client.GetEventGridNamespacePermissionBindingResource(eventGridNamespacePermissionBindingResourceId);

            // invoke the operation
            EventGridNamespacePermissionBindingData data = new EventGridNamespacePermissionBindingData()
            {
                TopicSpaceName = "exampleTopicSpaceName1",
                Permission = PermissionType.Publisher,
                ClientGroupName = "exampleClientGroupName1",
            };
            ArmOperation<EventGridNamespacePermissionBindingResource> lro = await eventGridNamespacePermissionBinding.UpdateAsync(WaitUntil.Completed, data);
            EventGridNamespacePermissionBindingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventGridNamespacePermissionBindingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PermissionBindings_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PermissionBindingsDelete()
        {
            // Generated from example definition: specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/PermissionBindings_Delete.json
            // this example is just showing the usage of "PermissionBindings_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventGridNamespacePermissionBindingResource created on azure
            // for more information of creating EventGridNamespacePermissionBindingResource, please refer to the document of EventGridNamespacePermissionBindingResource
            string subscriptionId = "8f6b6269-84f2-4d09-9e31-1127efcd1e40";
            string resourceGroupName = "examplerg";
            string namespaceName = "exampleNamespaceName1";
            string permissionBindingName = "examplePermissionBindingName1";
            ResourceIdentifier eventGridNamespacePermissionBindingResourceId = EventGridNamespacePermissionBindingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, permissionBindingName);
            EventGridNamespacePermissionBindingResource eventGridNamespacePermissionBinding = client.GetEventGridNamespacePermissionBindingResource(eventGridNamespacePermissionBindingResourceId);

            // invoke the operation
            await eventGridNamespacePermissionBinding.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
