// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.EventGrid.Models;

namespace Azure.ResourceManager.EventGrid.Samples
{
    public partial class Sample_EventGridNamespaceClientResource
    {
        // Clients_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ClientsGet()
        {
            // Generated from example definition: specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/Clients_Get.json
            // this example is just showing the usage of "Clients_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventGridNamespaceClientResource created on azure
            // for more information of creating EventGridNamespaceClientResource, please refer to the document of EventGridNamespaceClientResource
            string subscriptionId = "8f6b6269-84f2-4d09-9e31-1127efcd1e40";
            string resourceGroupName = "examplerg";
            string namespaceName = "exampleNamespaceName1";
            string clientName = "exampleClientName1";
            ResourceIdentifier eventGridNamespaceClientResourceId = EventGridNamespaceClientResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, clientName);
            EventGridNamespaceClientResource eventGridNamespaceClient = client.GetEventGridNamespaceClientResource(eventGridNamespaceClientResourceId);

            // invoke the operation
            EventGridNamespaceClientResource result = await eventGridNamespaceClient.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventGridNamespaceClientData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Clients_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ClientsCreateOrUpdate()
        {
            // Generated from example definition: specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/Clients_CreateOrUpdate.json
            // this example is just showing the usage of "Clients_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventGridNamespaceClientResource created on azure
            // for more information of creating EventGridNamespaceClientResource, please refer to the document of EventGridNamespaceClientResource
            string subscriptionId = "8f6b6269-84f2-4d09-9e31-1127efcd1e40";
            string resourceGroupName = "examplerg";
            string namespaceName = "exampleNamespaceName1";
            string clientName = "exampleClientName1";
            ResourceIdentifier eventGridNamespaceClientResourceId = EventGridNamespaceClientResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, clientName);
            EventGridNamespaceClientResource eventGridNamespaceClient = client.GetEventGridNamespaceClientResource(eventGridNamespaceClientResourceId);

            // invoke the operation
            EventGridNamespaceClientData data = new EventGridNamespaceClientData()
            {
                Description = "This is a test client",
                ClientCertificateAuthentication = new ClientCertificateAuthentication()
                {
                    ValidationScheme = ClientCertificateValidationScheme.SubjectMatchesAuthenticationName,
                },
                State = EventGridNamespaceClientState.Enabled,
                Attributes =
{
["deviceTypes"] = BinaryData.FromObjectAsJson(new object[] { "Fan", "Light", "AC" }),
["floor"] = BinaryData.FromString("\"3\""),
["room"] = BinaryData.FromString("\"345\""),
},
            };
            ArmOperation<EventGridNamespaceClientResource> lro = await eventGridNamespaceClient.UpdateAsync(WaitUntil.Completed, data);
            EventGridNamespaceClientResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventGridNamespaceClientData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Clients_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ClientsDelete()
        {
            // Generated from example definition: specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/Clients_Delete.json
            // this example is just showing the usage of "Clients_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventGridNamespaceClientResource created on azure
            // for more information of creating EventGridNamespaceClientResource, please refer to the document of EventGridNamespaceClientResource
            string subscriptionId = "8f6b6269-84f2-4d09-9e31-1127efcd1e40";
            string resourceGroupName = "examplerg";
            string namespaceName = "exampleNamespaceName1";
            string clientName = "exampleClientName1";
            ResourceIdentifier eventGridNamespaceClientResourceId = EventGridNamespaceClientResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, clientName);
            EventGridNamespaceClientResource eventGridNamespaceClient = client.GetEventGridNamespaceClientResource(eventGridNamespaceClientResourceId);

            // invoke the operation
            await eventGridNamespaceClient.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
