// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class WebAppServicePlanUpdatedEventDataSku
    {
        internal static WebAppServicePlanUpdatedEventDataSku DeserializeWebAppServicePlanUpdatedEventDataSku(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string tier = default;
            string size = default;
            string family = default;
            string capacity = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Tier"u8))
                {
                    tier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Size"u8))
                {
                    size = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Family"u8))
                {
                    family = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Capacity"u8))
                {
                    capacity = property.Value.GetString();
                    continue;
                }
            }
            return new WebAppServicePlanUpdatedEventDataSku(name, tier, size, family, capacity);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WebAppServicePlanUpdatedEventDataSku FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWebAppServicePlanUpdatedEventDataSku(document.RootElement);
        }
    }
}
